/*
 * Decompiled with CFR 0.152.
 */
package mod._nestedreg.uno;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.registry.InvalidRegistryException;
import com.sun.star.registry.XSimpleRegistry;
import com.sun.star.uno.XInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.RegistryTools;
import util.utils;

public class NestedRegistry
extends TestCase {
    protected static int uniq = 0;
    XSimpleRegistry reg1;
    XSimpleRegistry reg2;

    @Override
    public synchronized void disposeTestEnvironment(TestEnvironment tEnv, TestParameters tParam) {
        try {
            this.reg1.destroy();
            this.reg2.destroy();
        }
        catch (InvalidRegistryException invalidRegistryException) {
            // empty catch block
        }
    }

    protected void copyFile(String src, String dst, PrintWriter log) throws IOException {
        File srcF = new File(src);
        File dstF = new File(dst);
        if (dstF.exists()) {
            dstF.delete();
        }
        dstF.createNewFile();
        dstF.deleteOnExit();
        FileInputStream fIn = new FileInputStream(srcF);
        FileOutputStream fOut = new FileOutputStream(dstF);
        byte[] buf = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = fIn.read(buf)) > 0) {
            fOut.write(buf, 0, bytesRead);
        }
        fIn.close();
        fOut.close();
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        Object oInterface = null;
        Object fileAcc = null;
        String tmpDir = utils.getOfficeTempDirSys((XMultiServiceFactory)Param.getMSF());
        String openF = tmpDir + "XSimpleRegistry_open" + uniq + ".rdb";
        String destroyF = tmpDir + "XSimpleRegistry_destroy" + uniq + ".rdb";
        String mergeF = tmpDir + "XSimpleRegistry_merge" + uniq + ".rdb";
        ++uniq;
        log.println("creating copies of the registry for XSimpleRegistry");
        try {
            String source = utils.getFullTestDocName("XSimpleRegistry.rdb");
            this.copyFile(source, openF, log);
            this.copyFile(source, mergeF, log);
        }
        catch (IOException e) {
            log.println("Exception occured while copying files");
            e.printStackTrace(log);
            throw new StatusException("Exception occured while copying files", e);
        }
        try {
            XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
            this.reg1 = RegistryTools.createRegistryService(xMSF);
            this.reg1.open(mergeF, false, true);
            this.reg2 = RegistryTools.createRegistryService(xMSF);
            this.reg2.open(openF, false, true);
            Object[] arg = new XSimpleRegistry[]{this.reg1, this.reg2};
            oInterface = xMSF.createInstanceWithArguments("com.sun.star.comp.stoc.NestedRegistry", arg);
        }
        catch (Exception e) {
            log.println("Introspection Service not available");
        }
        oObj = (XInterface)oInterface;
        log.println("    creating a new environment for Introspection object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("NR", "NestedRegistry");
        tEnv.addObjRelation("XSimpleRegistry.open", openF);
        tEnv.addObjRelation("XSimpleRegistry.merge", mergeF);
        tEnv.addObjRelation("XSimpleRegistry.destroy", destroyF);
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
    }
}

