/*
 * Decompiled with CFR 0.152.
 */
package mod._jdbc;

import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;

public class JDBCDriver
extends TestCase {
    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        try {
            oObj = (XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.comp.sdbc.JDBCDriver");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't create object"));
        }
        log.println("creating a new environment for JDBCDriver object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        String jdbcURL = (String)Param.get("jdbc.url");
        if (jdbcURL == null) {
            throw new StatusException(Status.failed("Couldn't get 'jdbc.url' from ini-file"));
        }
        tEnv.addObjRelation("XDriver.URL", "jdbc:" + jdbcURL);
        String user = (String)Param.get("jdbc.user");
        String password = (String)Param.get("jdbc.password");
        if (user == null || password == null) {
            throw new StatusException(Status.failed("Couldn't get 'jdbc.user' or 'jdbc.password' from ini-file"));
        }
        PropertyValue[] info = new PropertyValue[4];
        info[0] = new PropertyValue();
        info[0].Name = "JavaDriverClass";
        info[0].Value = "org.gjt.mm.mysql.Driver";
        info[1] = new PropertyValue();
        info[1].Name = "user";
        info[1].Value = user;
        info[2] = new PropertyValue();
        info[2].Name = "password";
        info[2].Value = password;
        info[3] = new PropertyValue();
        info[3].Name = "isPasswordRequired";
        info[3].Value = new Boolean(true);
        tEnv.addObjRelation("XDriver.INFO", info);
        String flatUrl = (String)Param.get("flat.url");
        if (flatUrl == null) {
            throw new StatusException(Status.failed("Couldn't get 'flat.url' from ini-file"));
        }
        tEnv.addObjRelation("XDriver.UNSUITABLE_URL", "sdbc:flat:" + flatUrl);
        return tEnv;
    }
}

