/*
 * Decompiled with CFR 0.152.
 */
package mod._i18n;

import com.sun.star.lang.Locale;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;
import util.utils;

public class BreakIterator
extends TestCase {
    XComponent xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a drawdoc");
            this.xTextDoc = SOF.loadDocument(utils.getFullTestURL("Iterator.sxw"));
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't load document", e);
        }
    }

    @Override
    public TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XInterface oObj = null;
        Object oInterface = null;
        try {
            XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
            oInterface = xMSF.createInstance("com.sun.star.i18n.BreakIterator");
        }
        catch (Exception e) {
            log.println("Can't create an object.");
            throw new StatusException("Can't create an object", e);
        }
        oObj = (XInterface)oInterface;
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("Locale", new Locale("en", "US", ""));
        XTextDocument xDoc = UnoRuntime.queryInterface(XTextDocument.class, (Object)this.xTextDoc);
        XText xTextRange = xDoc.getText();
        tEnv.addObjRelation("UnicodeString", xTextRange.getString());
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        this.xTextDoc.dispose();
    }
}

