/*
 * Decompiled with CFR 0.152.
 */
package mod._fwl;

import com.sun.star.beans.NamedValue;
import com.sun.star.beans.PropertyValue;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class TypeDetection
extends TestCase {
    XTextDocument xTextDoc = null;

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        DesktopTools.closeDoc(this.xTextDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        Object oInterface = null;
        try {
            oInterface = ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.document.TypeDetection");
        }
        catch (Exception e) {
            log.println("Couldn't get service");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get TypeDetection", e);
        }
        if (oInterface == null) {
            log.println("Service wasn't created");
            throw new StatusException(Status.failed("Service wasn't created"));
        }
        oObj = (XInterface)oInterface;
        log.println("ImplName: " + utils.getImplName(oObj));
        log.println("creating a new environment for object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        XNameAccess xNA = UnoRuntime.queryInterface(XNameAccess.class, (Object)oObj);
        String[] elementNames = xNA.getElementNames();
        String elementName = elementNames[0];
        Object[] instance = null;
        try {
            instance = (Object[])xNA.getByName(elementName);
        }
        catch (NoSuchElementException e) {
            throw new StatusException(Status.failed("Couldn't get elements from object"));
        }
        catch (WrappedTargetException e) {
            throw new StatusException(Status.failed("Couldn't get elements from object"));
        }
        log.println("adding INSTANCE 1 as obj relation to environment");
        this.setPropertyValueValue((PropertyValue[])instance, "Preferred", "INSTANCE1");
        tEnv.addObjRelation("INSTANCE1", instance);
        NamedValue[] querySequenze = new NamedValue[1];
        NamedValue query = new NamedValue();
        query.Name = "Name";
        query.Value = "writer_Text";
        querySequenze[0] = query;
        log.println("create text document with bookmarks");
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        String fileURL = null;
        try {
            this.xTextDoc = SOF.createTextDoc(null);
            XTextContent xBookMark = SOfficeFactory.createBookmark(this.xTextDoc);
            SOfficeFactory.insertTextContent(this.xTextDoc, xBookMark);
            fileURL = utils.getOfficeTemp((XMultiServiceFactory)Param.getMSF());
            fileURL = fileURL + "bookmarks.oot";
            XStorable store = UnoRuntime.queryInterface(XStorable.class, (Object)this.xTextDoc);
            System.out.println(fileURL);
            store.storeToURL(fileURL, new PropertyValue[0]);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create Bookmark", e);
        }
        tEnv.addObjRelation("XContainerQuery.createSubSetEnumerationByProperties", querySequenze);
        tEnv.addObjRelation("XTypeDetection.bookmarkDoc", fileURL + "#bookmark");
        return tEnv;
    }

    protected void setPropertyValueValue(PropertyValue[] props, String pName, Object pValue) {
        for (int i = 0; i < props.length && !props[i].Name.equals(pName); ++i) {
        }
        props[i].Value = pValue;
    }
}

