/*
 * Decompiled with CFR 0.152.
 */
package mod._fwl;

import com.sun.star.beans.NamedValue;
import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import java.util.HashSet;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.utils;

public class PathSettings
extends TestCase {
    private static NamedValue[] m_Properties;
    private static XPropertySet xPS;

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("restore old values of path settings...");
        for (int i = 0; i < m_Properties.length; ++i) {
            try {
                xPS.setPropertyValue(PathSettings.m_Properties[i].Name, PathSettings.m_Properties[i].Value);
                continue;
            }
            catch (UnknownPropertyException e) {
                continue;
            }
            catch (PropertyVetoException e) {
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (WrappedTargetException e) {
                // empty catch block
            }
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        Object oInterface = null;
        try {
            oInterface = ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.comp.framework.PathSettings");
        }
        catch (Exception e) {
            log.println("Couldn't get service");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get GridControl", e);
        }
        if (oInterface == null) {
            log.println("Service wasn't created");
            throw new StatusException(Status.failed("Service wasn't created"));
        }
        oObj = (XInterface)oInterface;
        log.println("ImplName: " + utils.getImplName(oObj));
        log.println("creating a new environment for object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        HashSet<String> exclProps = new HashSet<String>();
        exclProps.add("UIConfig");
        tEnv.addObjRelation("XFastPropertySet.ExcludeProps", exclProps);
        tEnv.addObjRelation("XMultiPropertySet.ExcludeProps", exclProps);
        this.saveAllPropertyValues(oObj);
        return tEnv;
    }

    private void saveAllPropertyValues(XInterface oObj) {
        xPS = UnoRuntime.queryInterface(XPropertySet.class, (Object)oObj);
        XPropertySetInfo xPSI = xPS.getPropertySetInfo();
        Property[] allProperties = xPSI.getProperties();
        m_Properties = new NamedValue[allProperties.length];
        for (int i = 0; i < allProperties.length; ++i) {
            try {
                PathSettings.m_Properties[i] = new NamedValue(allProperties[i].Name, xPS.getPropertyValue(allProperties[i].Name));
                continue;
            }
            catch (UnknownPropertyException e) {
                continue;
            }
            catch (WrappedTargetException e) {
                // empty catch block
            }
        }
    }
}

