/*
 * Decompiled with CFR 0.152.
 */
package mod._fwl;

import com.sun.star.beans.NamedValue;
import com.sun.star.beans.PropertyValue;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import java.util.Vector;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.utils;

public class FilterFactory
extends TestCase {
    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        Object oInterface = null;
        try {
            oInterface = ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.document.FilterFactory");
        }
        catch (Exception e) {
            log.println("Couldn't get service");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get FilterFactory", e);
        }
        if (oInterface == null) {
            log.println("Service wasn't created");
            throw new StatusException(Status.failed("Service wasn't created"));
        }
        oObj = (XInterface)oInterface;
        log.println("ImplName: " + utils.getImplName(oObj));
        log.println("creating a new environment for object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        XNameAccess xNA = UnoRuntime.queryInterface(XNameAccess.class, (Object)oObj);
        String[] filterNames = xNA.getElementNames();
        String filterName = filterNames[0];
        Object[] instance = null;
        PropertyValue instanceProp = new PropertyValue();
        try {
            instance = (Object[])xNA.getByName(filterName);
            PropertyValue[] props = (PropertyValue[])instance;
            instanceProp = this.getPropertyValue((PropertyValue[])instance, "FilterService");
        }
        catch (NoSuchElementException e) {
            throw new StatusException(Status.failed("Couldn't get elements from object"));
        }
        catch (WrappedTargetException e) {
            throw new StatusException(Status.failed("Couldn't get elements from object"));
        }
        log.println("adding INSTANCE 1 as obj relation to environment");
        log.println("fill property 'TemplateName' with 'INSTANCE1'");
        this.setPropertyValueValue((PropertyValue[])instance, "TemplateName", "INSTANCE1");
        tEnv.addObjRelation("INSTANCE1", instance);
        Vector<String> vFTypes = new Vector<String>();
        Vector<Object[]> vFArgs = new Vector<Object[]>();
        for (int i = 0; i < filterNames.length; ++i) {
            PropertyValue[] filterProps = null;
            try {
                System.out.println(filterNames[i]);
                filterProps = (PropertyValue[])xNA.getByName(filterNames[i]);
            }
            catch (WrappedTargetException e) {
                throw new StatusException("Couldn't create relation", e);
            }
            catch (NoSuchElementException e) {
                throw new StatusException("Couldn't create relation", e);
            }
            String filterImpl = (String)this.getPropertyValueValue(filterProps, "FilterService");
            if (filterImpl == null || filterImpl.length() <= 0) continue;
            String filterType = (String)this.getPropertyValueValue(filterProps, "Type");
            vFTypes.add(filterType);
            PropertyValue prop = new PropertyValue();
            prop.Name = "FilterName";
            prop.Value = filterNames[i];
            vFArgs.add(new Object[]{prop});
            log.println("Found filter '" + filterNames[i] + "', type: " + filterType + ", service name: '" + filterImpl + "'");
        }
        tEnv.addObjRelation("XMSF.serviceNamesWithArgs", vFTypes.toArray(new String[vFTypes.size()]));
        tEnv.addObjRelation("XMSF.Args", vFArgs.toArray((T[])new Object[vFArgs.size()][]));
        NamedValue[] querySequenze = new NamedValue[1];
        NamedValue query = new NamedValue();
        query.Name = "Name";
        query.Value = "Rich Text Format";
        querySequenze[0] = query;
        tEnv.addObjRelation("XContainerQuery.createSubSetEnumerationByProperties", querySequenze);
        return tEnv;
    }

    protected Object getPropertyValueValue(PropertyValue[] props, String pName) {
        int i;
        for (i = 0; i < props.length && !props[i].Name.equals(pName); ++i) {
        }
        return i < props.length ? props[i].Value : null;
    }

    protected void setPropertyValueValue(PropertyValue[] props, String pName, Object pValue) {
        for (int i = 0; i < props.length && !props[i].Name.equals(pName); ++i) {
        }
        props[i].Value = pValue;
    }

    protected PropertyValue getPropertyValue(PropertyValue[] props, String pName) {
        int i;
        for (i = 0; i < props.length && !props[i].Name.equals(pName); ++i) {
        }
        return i < props.length ? props[i] : null;
    }
}

