/*
 * Decompiled with CFR 0.152.
 */
package mod._fwk;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XIndexContainer;
import com.sun.star.embed.XStorage;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalAccessException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.ui.ConfigurationEvent;
import com.sun.star.ui.XUIConfigurationManager;
import com.sun.star.ui.XUIConfigurationStorage;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.ui._XUIConfiguration;
import ifc.ui._XUIConfigurationManager;
import java.io.PrintWriter;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.dbg;
import util.utils;

public class UIConfigurationManager
extends TestCase {
    XUIConfigurationManager xManager = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        TestEnvironment tEnv = null;
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        log.println("Creating instance...");
        try {
            this.xManager = UnoRuntime.queryInterface(XUIConfigurationManager.class, xMSF.createInstance("com.sun.star.comp.framework.UIConfigurationManager"));
        }
        catch (Exception e) {
            // empty catch block
        }
        log.println("TestObject: " + utils.getImplName(this.xManager));
        tEnv = new TestEnvironment(this.xManager);
        try {
            String sourceDeleteCfg = utils.getFullTestURL("delete.cfg");
            String deleteCfg = utils.getFullURL(utils.getOfficeTemp(xMSF) + "delete.cfg");
            utils.copyFile(xMSF, sourceDeleteCfg, deleteCfg);
            XStorage xSubStorage = null;
            XInterface o = (XInterface)xMSF.createInstance("com.sun.star.embed.StorageFactory");
            XSingleServiceFactory xSSF = UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)o);
            Object[] props = new Object[]{deleteCfg, new Integer(7)};
            XStorage xRootStorage = UnoRuntime.queryInterface(XStorage.class, xSSF.createInstanceWithArguments(props));
            xSubStorage = xRootStorage.openStorageElement("Configurations2", 7);
            XUIConfigurationStorage xConfigStorage = UnoRuntime.queryInterface(XUIConfigurationStorage.class, (Object)this.xManager);
            xConfigStorage.setStorage(xSubStorage);
            tEnv.addObjRelation("XUIConfigurationStorage.Storage", xSubStorage);
        }
        catch (Exception e) {
            log.println("Could not create storage: " + e.toString());
        }
        dbg.printInterfaces(this.xManager);
        tEnv.addObjRelation("XUIConfiguration.XUIConfigurationListenerImpl", new ConfigurationListener(log, this.xManager, xMSF));
        tEnv.addObjRelation("XConfigurationManager.ShortCutManager", "com.sun.star.ui.DocumentAcceleratorConfiguration");
        return tEnv;
    }

    public static class ConfigurationListener
    implements _XUIConfiguration.XUIConfigurationListenerImpl {
        private boolean triggered = false;
        private PrintWriter log = null;
        private XUIConfigurationManager xUIManager = null;
        private XMultiServiceFactory xMSF = null;
        private static int iUniqueCounter;

        public ConfigurationListener(PrintWriter _log, XUIConfigurationManager xUIManager, XMultiServiceFactory xMSF) {
            this.log = _log;
            this.xUIManager = xUIManager;
            this.xMSF = xMSF;
            iUniqueCounter = 0;
        }

        @Override
        public void reset() {
            this.triggered = false;
        }

        @Override
        public void fireEvent() {
            try {
                if (iUniqueCounter == 0) {
                    ++iUniqueCounter;
                    PropertyValue[][] props = this.xUIManager.getUIElementsInfo((short)0);
                    XIndexAccess xMenuBarSettings = this.xUIManager.getSettings("private:resource/menubar/menubar", true);
                    PropertyValue[] prop = _XUIConfigurationManager.createMenuBarEntry("Trigger Event", xMenuBarSettings, this.xMSF, this.log);
                    _XUIConfigurationManager.createMenuBarItem("Click for Macro", UnoRuntime.queryInterface(XIndexContainer.class, prop[3].Value), this.log);
                    XIndexContainer x = UnoRuntime.queryInterface(XIndexContainer.class, (Object)xMenuBarSettings);
                    x.insertByIndex(x.getCount(), prop);
                    this.xUIManager.replaceSettings("private:resource/menubar/menubar", xMenuBarSettings);
                    this.xUIManager.reset();
                }
            }
            catch (NoSuchElementException e) {
                this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl: Exception.");
                e.printStackTrace(this.log);
            }
            catch (IllegalArgumentException e) {
                this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl: Exception.");
                e.printStackTrace(this.log);
            }
            catch (IllegalAccessException e) {
                this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl: Exception.");
                e.printStackTrace(this.log);
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl: Exception.");
                e.printStackTrace(this.log);
            }
            catch (WrappedTargetException e) {
                this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl: Exception.");
                e.printStackTrace(this.log);
            }
        }

        @Override
        public boolean actionWasTriggered() {
            return this.triggered;
        }

        @Override
        public void disposing(EventObject e) {
            this.triggered = true;
            this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl.disposing the listener.");
        }

        @Override
        public void elementInserted(ConfigurationEvent configEvent) {
            this.triggered = true;
            this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl.elementInserted.");
        }

        @Override
        public void elementRemoved(ConfigurationEvent configEvent) {
            this.triggered = true;
            this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl.elementRemoved.");
        }

        @Override
        public void elementReplaced(ConfigurationEvent configEvent) {
            this.triggered = true;
            this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl.elementReplaced.");
        }
    }
}

