/*
 * Decompiled with CFR 0.152.
 */
package mod._fwk;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XIndexContainer;
import com.sun.star.container.XNameAccess;
import com.sun.star.embed.XStorage;
import com.sun.star.embed.XTransactedObject;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalAccessException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.ui.ConfigurationEvent;
import com.sun.star.ui.XModuleUIConfigurationManagerSupplier;
import com.sun.star.ui.XUIConfigurationManager;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import ifc.ui._XUIConfiguration;
import ifc.ui._XUIConfigurationManager;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.WriterTools;
import util.dbg;
import util.utils;

public class ModuleUIConfigurationManager
extends TestCase {
    XInterface oObj = null;
    XMultiServiceFactory xMSF = null;
    XTextDocument xTextDoc = null;
    XStorage xStore = null;

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        try {
            XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, (Object)this.xTextDoc);
            closer.close(true);
        }
        catch (CloseVetoException e) {
            log.println("couldn't close document");
        }
        catch (DisposedException e) {
            log.println("couldn't close document");
        }
        log.println("   disposing storage");
        this.xStore.dispose();
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        TestEnvironment tEnv = null;
        try {
            this.xMSF = (XMultiServiceFactory)tParam.getMSF();
            log.println("Creating instance...");
            this.xTextDoc = WriterTools.createTextDoc(this.xMSF);
            Object o = (XInterface)this.xMSF.createInstance("com.sun.star.ui.ModuleUIConfigurationManagerSupplier");
            XModuleUIConfigurationManagerSupplier xMUICMS = UnoRuntime.queryInterface(XModuleUIConfigurationManagerSupplier.class, o);
            dbg.printInterfaces(xMUICMS);
            this.oObj = xMUICMS.getUIConfigurationManager("com.sun.star.text.TextDocument");
            log.println("TestObject: " + utils.getImplName(this.oObj));
            tEnv = new TestEnvironment(this.oObj);
            XNameAccess xMM = UnoRuntime.queryInterface(XNameAccess.class, this.xMSF.createInstance("com.sun.star.comp.framework.ModuleManager"));
            String[] names = xMM.getElementNames();
            o = this.xMSF.createInstance("com.sun.star.embed.StorageFactory");
            XSingleServiceFactory xStorageService = UnoRuntime.queryInterface(XSingleServiceFactory.class, o);
            Object[] props = new Object[2];
            String aFile = utils.getOfficeTempDir(this.xMSF) + "dummyFile.dat";
            log.println("storage file : '" + aFile + "'");
            props[0] = aFile;
            props[1] = new Integer(7);
            this.xStore = UnoRuntime.queryInterface(XStorage.class, xStorageService.createInstanceWithArguments(props));
            PropertyValue[] initProps = new PropertyValue[4];
            PropertyValue propVal = new PropertyValue();
            propVal.Name = "DefaultConfigStorage";
            propVal.Value = this.xStore;
            initProps[0] = propVal;
            propVal = new PropertyValue();
            propVal.Name = "UserConfigStorage";
            propVal.Value = this.xStore;
            initProps[1] = propVal;
            propVal = new PropertyValue();
            propVal.Name = "ModuleIdentifier";
            propVal.Value = "swriter";
            initProps[2] = propVal;
            propVal = new PropertyValue();
            propVal.Name = "UserRootCommit";
            propVal.Value = UnoRuntime.queryInterface(XTransactedObject.class, (Object)this.xStore);
            initProps[3] = propVal;
            tEnv.addObjRelation("XInitialization.args", initProps);
            tEnv.addObjRelation("XConfigurationManager.ShortCutManager", "com.sun.star.ui.ModuleAcceleratorConfiguration");
            tEnv.addObjRelation("XModuleUIConfigurationManager.ResourceURL", "private:resource/menubar/menubar");
            tEnv.addObjRelation("XUIConfiguration.XUIConfigurationListenerImpl", new ConfigurationListener(log, UnoRuntime.queryInterface(XUIConfigurationManager.class, (Object)this.oObj), this.xMSF));
            tEnv.addObjRelation("XModuleUIConfigurationManagerSupplier.ConfigManagerImplementationName", "com.sun.star.comp.framework.ModuleUIConfigurationManager");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Cannot create test object", e);
        }
        return tEnv;
    }

    public static class ConfigurationListener
    implements _XUIConfiguration.XUIConfigurationListenerImpl {
        private boolean triggered = false;
        private PrintWriter log = null;
        private XUIConfigurationManager xUIManager = null;
        private XMultiServiceFactory xMSF = null;

        public ConfigurationListener(PrintWriter _log, XUIConfigurationManager xUIManager, XMultiServiceFactory xMSF) {
            this.log = _log;
            this.xUIManager = xUIManager;
            this.xMSF = xMSF;
        }

        @Override
        public void reset() {
            this.triggered = false;
        }

        @Override
        public void fireEvent() {
            try {
                XIndexAccess xMenuBarSettings = this.xUIManager.getSettings("private:resource/menubar/menubar", true);
                PropertyValue[] prop = _XUIConfigurationManager.createMenuBarEntry("Trigger Event", xMenuBarSettings, this.xMSF, this.log);
                _XUIConfigurationManager.createMenuBarItem("Click for Macro", UnoRuntime.queryInterface(XIndexContainer.class, prop[3].Value), this.log);
                XIndexContainer x = UnoRuntime.queryInterface(XIndexContainer.class, (Object)xMenuBarSettings);
                x.insertByIndex(x.getCount(), prop);
                this.xUIManager.replaceSettings("private:resource/menubar/menubar", xMenuBarSettings);
                this.xUIManager.reset();
            }
            catch (NoSuchElementException e) {
                this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl: Exception.");
                e.printStackTrace(this.log);
            }
            catch (IllegalArgumentException e) {
                this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl: Exception.");
                e.printStackTrace(this.log);
            }
            catch (IllegalAccessException e) {
                this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl: Exception.");
                e.printStackTrace(this.log);
            }
            catch (IndexOutOfBoundsException e) {
                this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl: Exception.");
                e.printStackTrace(this.log);
            }
            catch (WrappedTargetException e) {
                this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl: Exception.");
                e.printStackTrace(this.log);
            }
        }

        @Override
        public boolean actionWasTriggered() {
            return this.triggered;
        }

        @Override
        public void disposing(EventObject e) {
            this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl.disposing the listener.");
        }

        @Override
        public void elementInserted(ConfigurationEvent configEvent) {
            this.triggered = true;
            this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl.elementInserted.");
        }

        @Override
        public void elementRemoved(ConfigurationEvent configEvent) {
            this.triggered = true;
            this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl.elementRemoved.");
        }

        @Override
        public void elementReplaced(ConfigurationEvent configEvent) {
            this.triggered = true;
            this.log.println("_XUIConfiguration.XUIConfigurationListenerImpl.elementReplaced.");
        }
    }
}

