/*
 * Decompiled with CFR 0.152.
 */
package mod._fwk;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XHierarchicalNameAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNameReplace;
import com.sun.star.container.XNamed;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XChangesBatch;
import java.io.PrintWriter;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import mod._fwk.Job;

public class JobExecutor
extends TestCase {
    static Job job = new Job();
    XNamed xNamed = null;
    Object oRootCfg = null;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        boolean serviceRegistered = false;
        boolean configured = false;
        try {
            Object obj = ((XMultiServiceFactory)Param.getMSF()).createInstance("test.Job");
            serviceRegistered = obj != null;
        }
        catch (com.sun.star.uno.Exception e) {
            // empty catch block
        }
        log.println("Service test.Job is " + (serviceRegistered ? "already" : "not yet") + " registered.");
        if (!serviceRegistered) {
            String message = "You have to register 'test.Job' before office is stared.\n";
            message = message + "Please run '$OFFICEPATH/program/pkgchk $DOCPTH/qadevlibs/JobExecutor.jar'";
            throw new StatusException(message, new Exception());
        }
        XNameAccess jobs = null;
        XNameAccess events = null;
        try {
            Object obj = ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.configuration.ConfigurationProvider");
            XMultiServiceFactory xConfigMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, obj);
            Object[] args = new PropertyValue[]{new PropertyValue()};
            args[0].Name = "nodepath";
            args[0].Value = "org.openoffice.Office.Jobs";
            this.oRootCfg = xConfigMSF.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess", args);
            XHierarchicalNameAccess xHNA = UnoRuntime.queryInterface(XHierarchicalNameAccess.class, this.oRootCfg);
            obj = xHNA.getByHierarchicalName("Jobs");
            jobs = UnoRuntime.queryInterface(XNameAccess.class, obj);
            obj = xHNA.getByHierarchicalName("Events");
            events = UnoRuntime.queryInterface(XNameAccess.class, obj);
        }
        catch (Exception e) {
            throw new StatusException("Couldn't get configuration", e);
        }
        configured = jobs.hasByName("TestJob") && events.hasByName("TestEvent");
        log.println("Test job and event is " + (configured ? "already" : "not yet") + " configured.");
        if (!configured) {
            try {
                log.println("Adding configuration to Jobs  ...");
                XSingleServiceFactory jobsFac = UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)jobs);
                Object oNewJob = jobsFac.createInstance();
                XNameReplace xNewJobNR = UnoRuntime.queryInterface(XNameReplace.class, oNewJob);
                xNewJobNR.replaceByName("Service", "test.Job");
                XNameContainer xJobsNC = UnoRuntime.queryInterface(XNameContainer.class, (Object)jobs);
                xJobsNC.insertByName("TestJob", oNewJob);
                log.println("Adding configuration to Events  ...");
                XSingleServiceFactory eventsFac = UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)events);
                Object oNewEvent = eventsFac.createInstance();
                XNameAccess xNewEventNA = UnoRuntime.queryInterface(XNameAccess.class, oNewEvent);
                Object oJobList = xNewEventNA.getByName("JobList");
                XSingleServiceFactory jobListFac = (XSingleServiceFactory)AnyConverter.toObject((Type)new Type(XSingleServiceFactory.class), (Object)oJobList);
                XNameContainer jobListNC = (XNameContainer)AnyConverter.toObject((Type)new Type(XNameContainer.class), (Object)oJobList);
                log.println("\tAdding TimeStamps to Events ...");
                Object oNewJobTimeStamps = jobListFac.createInstance();
                jobListNC.insertByName("TestJob", oNewJobTimeStamps);
                XNameContainer xEventsNC = UnoRuntime.queryInterface(XNameContainer.class, (Object)events);
                xEventsNC.insertByName("TestEvent", oNewEvent);
                XChangesBatch xCB = UnoRuntime.queryInterface(XChangesBatch.class, this.oRootCfg);
                xCB.commitChanges();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {}
            }
            catch (com.sun.star.uno.Exception e) {
                e.printStackTrace(log);
                throw new StatusException("Couldn't change config", e);
            }
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        XInterface job = null;
        try {
            oObj = (XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.comp.framework.JobExecutor");
            job = (XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("test.Job");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't create instance"));
        }
        this.xNamed = UnoRuntime.queryInterface(XNamed.class, (Object)job);
        log.println("Count = " + this.xNamed.getName());
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("CallCounter", this.xNamed);
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
    }
}

