/*
 * Decompiled with CFR 0.152.
 */
package mod._fwk;

import com.sun.star.document.XDocumentInfo;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class DocumentProperties
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xTextDoc");
        if (this.xTextDoc != null) {
            this.xTextDoc.dispose();
        }
    }

    @Override
    public TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XDocumentInfo oObj = null;
        log.println("creating a test environment");
        if (this.xTextDoc != null) {
            this.xTextDoc.dispose();
        }
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a text document");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        this.shortWait();
        XDocumentInfoSupplier xdis = UnoRuntime.queryInterface(XDocumentInfoSupplier.class, (Object)this.xTextDoc);
        oObj = xdis.getDocumentInfo();
        TestEnvironment tEnv = new TestEnvironment(oObj);
        return tEnv;
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }
}

