/*
 * Decompiled with CFR 0.152.
 */
package mod._fwk;

import com.sun.star.frame.XDesktop;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;

public class Desktop
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xTextDoc");
        if (this.xTextDoc != null) {
            try {
                this.xTextDoc.dispose();
            }
            catch (DisposedException disposedException) {
                // empty catch block
            }
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a text document");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        XInterface oObj = null;
        try {
            oObj = (XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.comp.framework.Desktop");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't create instance"));
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("XDispatchProvider.URL", ".uno:Open");
        tEnv.addObjRelation("Desktop", UnoRuntime.queryInterface(XDesktop.class, (Object)oObj));
        return tEnv;
    }
}

