/*
 * Decompiled with CFR 0.152.
 */
package mod._forms;

import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDevice;
import com.sun.star.awt.XGraphics;
import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.drawing.XControlShape;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.view.XControlAccess;
import ifc.awt._XTextListener;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.FormTools;
import util.SOfficeFactory;
import util.WriterTools;

public class OTimeControl
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        try {
            XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, (Object)this.xTextDoc);
            closer.close(true);
        }
        catch (CloseVetoException e) {
            log.println("couldn't close document");
        }
        catch (DisposedException e) {
            log.println("couldn't close document");
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XControl oObj = null;
        XWindowPeer the_win = null;
        XToolkit the_kit = null;
        XDevice aDevice = null;
        XGraphics aGraphic = null;
        XControl aControl = null;
        XControlShape aShape = FormTools.createControlShape(this.xTextDoc, 3000, 4500, 15000, 10000, "TimeField");
        WriterTools.getDrawPage(this.xTextDoc).add(aShape);
        XControlModel the_Model = aShape.getControl();
        XControlShape aShape2 = FormTools.createControlShape(this.xTextDoc, 3000, 4500, 5000, 10000, "TextField");
        WriterTools.getDrawPage(this.xTextDoc).add(aShape2);
        XControlModel the_Model2 = aShape2.getControl();
        XControlAccess the_access = UnoRuntime.queryInterface(XControlAccess.class, (Object)this.xTextDoc.getCurrentController());
        try {
            oObj = the_access.getControl(the_Model);
            aControl = the_access.getControl(the_Model2);
            the_win = the_access.getControl(the_Model).getPeer();
            the_kit = the_win.getToolkit();
            aDevice = the_kit.createScreenCompatibleDevice(200, 200);
            aGraphic = aDevice.createGraphics();
        }
        catch (NoSuchElementException e) {
            log.println("Couldn't get OTimeControl");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get OTimeControl", e);
        }
        log.println("creating a new environment for OTimeControl object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("GRAPHICS", aGraphic);
        tEnv.addObjRelation("CONTEXT", this.xTextDoc);
        tEnv.addObjRelation("WINPEER", the_win);
        tEnv.addObjRelation("TOOLKIT", the_kit);
        tEnv.addObjRelation("MODEL", the_Model);
        XWindow forObjRel = UnoRuntime.queryInterface(XWindow.class, (Object)aControl);
        tEnv.addObjRelation("XWindow.AnotherWindow", forObjRel);
        tEnv.addObjRelation("XWindow.ControlShape", aShape);
        _XTextListener.TestTextListener listener = new _XTextListener.TestTextListener();
        XTextComponent textComp = UnoRuntime.queryInterface(XTextComponent.class, (Object)oObj);
        textComp.addTextListener(listener);
        tEnv.addObjRelation("TestTextListener", listener);
        FormTools.switchDesignOf((XMultiServiceFactory)Param.getMSF(), this.xTextDoc);
        this.shortWait();
        return tEnv;
    }

    private void shortWait() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            System.out.println("While waiting :" + e);
        }
    }
}

