/*
 * Decompiled with CFR 0.152.
 */
package mod._forms;

import com.sun.star.awt.XControlModel;
import com.sun.star.beans.PropertyValue;
import com.sun.star.drawing.XControlShape;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import java.io.PrintWriter;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.FormTools;
import util.WriterTools;
import util.utils;

public class OScrollBarModel
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        log.println("creating a textdocument");
        this.xTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)tParam.getMSF());
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xTextDoc ");
        try {
            XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, (Object)this.xTextDoc);
            closer.close(true);
        }
        catch (CloseVetoException e) {
            log.println("couldn't close document");
        }
        catch (DisposedException e) {
            log.println("couldn't close document");
        }
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XControlModel oObj = null;
        XControlShape aShape = FormTools.createControlShape(this.xTextDoc, 3000, 4500, 15000, 10000, "ScrollBar");
        WriterTools.getDrawPage(this.xTextDoc).add(aShape);
        oObj = aShape.getControl();
        log.println("creating a new environment for OScrollBarModel object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        System.out.println("Implementation Name: " + utils.getImplName(oObj));
        String objName = "ScrollBar";
        tEnv.addObjRelation("OBJNAME", "com.sun.star.form.component." + objName);
        PropertyValue prop = new PropertyValue();
        prop.Name = "HelpText";
        prop.Value = "new Help Text since XPropertyAccess";
        tEnv.addObjRelation("XPropertyAccess.propertyToChange", prop);
        tEnv.addObjRelation("XPropertyContainer.propertyNotRemovable", "HelpText");
        return tEnv;
    }
}

