/*
 * Decompiled with CFR 0.152.
 */
package mod._forms;

import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import java.io.PrintWriter;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DrawTools;
import util.FormTools;

public class OFormsCollection
extends TestCase {
    XComponent xDrawDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        log.println("creating a draw document");
        this.xDrawDoc = DrawTools.createDrawDoc((XMultiServiceFactory)tParam.getMSF());
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xDrawDoc ");
        try {
            XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, (Object)this.xDrawDoc);
            closer.close(true);
        }
        catch (CloseVetoException e) {
            log.println("couldn't close document");
        }
        catch (DisposedException e) {
            log.println("couldn't close document");
        }
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XNameContainer oObj = null;
        XDrawPage oDP = null;
        log.println("creating a test environment");
        oDP = DrawTools.getDrawPage(this.xDrawDoc, 0);
        DrawTools.getShapes(oDP).add(FormTools.createControlShape(this.xDrawDoc, 2000, 1500, 1000, 1000, "CheckBox"));
        DrawTools.getShapes(oDP).add(FormTools.createControlShape(this.xDrawDoc, 3000, 4500, 15000, 1000, "CommandButton"));
        DrawTools.getShapes(oDP).add(FormTools.createControlShape(this.xDrawDoc, 5000, 3500, 7500, 5000, "TextField"));
        oObj = FormTools.getForms(oDP);
        FormTools.insertForm(this.xDrawDoc, oObj, "SecondForm");
        log.println("creating a new environment for drawpage object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("adding INSTANCEn as obj relation to environment");
        XComponent xComp = UnoRuntime.queryInterface(XComponent.class, (Object)this.xDrawDoc);
        int THRCNT = 1;
        if (Param.get("THRCNT") != null) {
            THRCNT = Integer.parseInt((String)Param.get("THRCNT"));
        }
        for (int n = 1; n < THRCNT + 1; ++n) {
            log.println("adding INSTANCE" + n + " as obj relation to environment");
            tEnv.addObjRelation("INSTANCE" + n, FormTools.createControl(xComp, "Form"));
        }
        tEnv.addObjRelation("XNameContainer.AllowDuplicateNames", new Object());
        tEnv.addObjRelation("INSTANCE", FormTools.createControl(xComp, "Form"));
        tEnv.addObjRelation("INSTANCE2", FormTools.createControl(xComp, "Form"));
        return tEnv;
    }
}

