/*
 * Decompiled with CFR 0.152.
 */
package mod._forms;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.awt.XControlModel;
import com.sun.star.beans.PropertyValue;
import com.sun.star.drawing.XControlShape;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import java.io.PrintWriter;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DrawTools;
import util.SOfficeFactory;

public class OFileControlModel
extends TestCase {
    XComponent xDrawDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a draw document");
            this.xDrawDoc = SOF.createDrawDoc(null);
        }
        catch (Exception e) {
            log.println("Can't create a document :");
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Can't create a document"));
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xDrawDoc ");
        try {
            XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, (Object)this.xDrawDoc);
            closer.close(true);
        }
        catch (CloseVetoException e) {
            log.println("couldn't close document");
        }
        catch (DisposedException e) {
            log.println("couldn't close document");
        }
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XControlModel oObj = null;
        log.println("creating a test environment");
        String objName = "FileControl";
        XControlShape aShape = null;
        Size size = new Size();
        Point position = new Point();
        XControlModel aControl = null;
        XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.xDrawDoc);
        try {
            Object oInt = oDocMSF.createInstance("com.sun.star.drawing.ControlShape");
            Object aCon = oDocMSF.createInstance("com.sun.star.form.component." + objName);
            aControl = UnoRuntime.queryInterface(XControlModel.class, aCon);
            aShape = UnoRuntime.queryInterface(XControlShape.class, oInt);
            size.Height = 1500;
            size.Width = 3000;
            position.X = 1000;
            position.Y = 1000;
            aShape.setSize(size);
            aShape.setPosition(position);
        }
        catch (Exception e) {
            log.println("Couldn't create a component " + e);
            throw new StatusException(Status.failed("Can't create component"));
        }
        aShape.setControl(aControl);
        DrawTools.getDrawPage(this.xDrawDoc, 0).add(aShape);
        oObj = aShape.getControl();
        log.println("creating a new environment for drawpage object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("OBJNAME", "stardiv.one.form.component." + objName);
        PropertyValue prop = new PropertyValue();
        prop.Name = "HelpText";
        prop.Value = "new Help Text since XPropertyAccess";
        tEnv.addObjRelation("XPropertyAccess.propertyToChange", prop);
        tEnv.addObjRelation("XPropertyContainer.propertyNotRemovable", "HelpText");
        return tEnv;
    }
}

