/*
 * Decompiled with CFR 0.152.
 */
package mod._forms;

import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNamed;
import com.sun.star.drawing.XControlShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.form.DatabaseParameterEvent;
import com.sun.star.form.XForm;
import com.sun.star.form.XLoadable;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.ParametersRequest;
import com.sun.star.sdb.RowChangeEvent;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XResultSetUpdate;
import com.sun.star.sdbc.XRow;
import com.sun.star.sdbc.XRowSet;
import com.sun.star.sdbc.XRowUpdate;
import com.sun.star.task.XInteractionRequest;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.Date;
import com.sun.star.util.DateTime;
import com.sun.star.util.Time;
import com.sun.star.util.XCloseable;
import com.sun.star.view.XControlAccess;
import ifc.form._XDatabaseParameterBroadcaster;
import ifc.sdb._XCompletedExecution;
import ifc.sdb._XRowSetApproveBroadcaster;
import ifc.sdbc._XResultSetUpdate;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Vector;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DBTools;
import util.DrawTools;
import util.FormTools;
import util.WriterTools;
import util.utils;

public class ODatabaseForm
extends TestCase {
    protected static final String dbSourceName = "ODatabaseFormDataSource";
    private static int uniqueSuffix = 0;
    private static String origDB = null;
    private static String tmpDir = null;
    protected XTextDocument xTextDoc = null;
    private DBTools dbTools = null;
    String tableName = null;
    DBTools.DataSourceInfo srcInf = null;
    boolean isMySQLDB = false;
    protected XConnection conn = null;
    private Object dbSrc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        tmpDir = utils.getOfficeTemp((XMultiServiceFactory)tParam.getMSF());
        origDB = utils.getFullTestDocName("TestDB/testDB.dbf");
        this.dbTools = new DBTools((XMultiServiceFactory)tParam.getMSF());
        String dbURL = (String)tParam.get("test.db.url");
        String dbUser = (String)tParam.get("test.db.user");
        String dbPassword = (String)tParam.get("test.db.password");
        log.println("Creating and registering DataSource ...");
        this.srcInf = this.dbTools.newDataSourceInfo();
        if (dbURL != null && dbUser != null && dbPassword != null) {
            this.isMySQLDB = true;
            log.println("dbURL = " + dbURL);
            log.println("dbUSER = " + dbUser);
            log.println("dbPASSWORD = " + dbPassword);
            try {
                this.tableName = "soffice_test_table";
                this.srcInf.URL = "jdbc:" + dbURL;
                this.srcInf.IsPasswordRequired = new Boolean(true);
                this.srcInf.Password = dbPassword;
                this.srcInf.User = dbUser;
                PropertyValue[] propInfo = new PropertyValue[]{new PropertyValue()};
                propInfo[0].Name = "JavaDriverClass";
                propInfo[0].Value = "util.dddriver.Driver";
                this.srcInf.Info = propInfo;
                this.dbSrc = this.srcInf.getDataSourceService();
                this.dbTools.reRegisterDB(dbSourceName, this.dbSrc);
            }
            catch (com.sun.star.uno.Exception e) {
                log.println("Error while object test initialization :");
                e.printStackTrace(log);
                throw new StatusException("Error while object test initialization", e);
            }
        }
        try {
            String myDbUrl;
            this.srcInf.URL = myDbUrl = "sdbc:dbase:" + DBTools.dirToUrl(tmpDir);
            log.println("try to register '" + myDbUrl + "' as '" + dbSourceName + "'");
            this.dbSrc = this.srcInf.getDataSourceService();
            this.dbTools.reRegisterDB(dbSourceName, this.dbSrc);
        }
        catch (com.sun.star.uno.Exception e) {
            log.println("Error while object test initialization :");
            e.printStackTrace(log);
            throw new StatusException("Error while object test initialization", e);
        }
        String oldF = null;
        String newF = null;
        do {
            this.tableName = "ODatabaseForm_tmp" + uniqueSuffix;
            oldF = utils.getFullURL(origDB);
            newF = utils.getOfficeTemp((XMultiServiceFactory)tParam.getMSF()) + this.tableName + ".dbf";
        } while (!utils.overwriteFile((XMultiServiceFactory)tParam.getMSF(), oldF, newF) && uniqueSuffix++ < 50);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XNamed elemName;
        String[] formNames;
        if (this.xTextDoc != null) {
            try {
                XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, (Object)this.xTextDoc);
                closer.close(true);
            }
            catch (CloseVetoException e) {
                log.println("couldn't close document");
            }
            catch (DisposedException e) {
                log.println("couldn't close document");
            }
            log.println("Existing document disposed");
        }
        log.println("creating a text document");
        this.xTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)Param.getMSF());
        if (this.isMySQLDB) {
            try {
                this.dbTools.initTestTableUsingJDBC(this.tableName, this.srcInf);
            }
            catch (SQLException e) {
                e.printStackTrace(log);
                throw new StatusException(Status.failed("Couldn't  init test table. SQLException..."));
            }
            catch (ClassNotFoundException e) {
                throw new StatusException(Status.failed("Couldn't register mysql driver"));
            }
        }
        XForm oObj = null;
        XShapes oShapes = null;
        XInterface oInstance = null;
        XConnection connection = null;
        log.println("creating a test environment");
        XNameContainer forms = FormTools.getForms(WriterTools.getDrawPage(this.xTextDoc));
        try {
            formNames = forms.getElementNames();
            for (int i = 0; i < formNames.length; ++i) {
                log.println("Removing form '" + formNames[i] + "' ...");
                forms.removeByName(formNames[i]);
            }
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace(log);
        }
        formNames = forms.getElementNames();
        FormTools.insertForm(this.xTextDoc, forms, "MyForm");
        formNames = forms.getElementNames();
        XLoadable formLoader = null;
        try {
            formLoader = FormTools.bindForm(this.xTextDoc, "MyForm", dbSourceName, this.tableName);
        }
        catch (com.sun.star.uno.Exception e) {
            log.println("Cann't bind the form to source 'ODatabaseFormDataSource', table '" + this.tableName + "' :");
            e.printStackTrace(log);
            throw new StatusException("Cann't bind a form", e);
        }
        log.println("Forms before adding controls : ");
        formNames = forms.getElementNames();
        for (int i = 0; i < formNames.length; ++i) {
            log.println("    '" + formNames[i] + "'");
        }
        XControlShape shape1 = null;
        XControlShape shape2 = null;
        try {
            log.println("Elements in the 'MyForm' :");
            XIndexAccess formElements1 = UnoRuntime.queryInterface(XIndexAccess.class, forms.getByName("MyForm"));
            for (int i = 0; i < formElements1.getCount(); ++i) {
                elemName = UnoRuntime.queryInterface(XNamed.class, formElements1.getByIndex(i));
                log.println("   '" + elemName.getName() + "'");
            }
            log.println("inserting some ControlShapes");
            oShapes = DrawTools.getShapes(WriterTools.getDrawPage(this.xTextDoc));
            shape1 = FormTools.createControlShape(this.xTextDoc, 3000, 4500, 15000, 1000, "CommandButton");
            shape2 = FormTools.createControlShape(this.xTextDoc, 5000, 3500, 7500, 5000, "TextField");
            XControlShape shape3 = FormTools.createControlShape(this.xTextDoc, 2000, 1500, 1000, 1000, "CheckBox");
            oShapes.add(shape1);
            oShapes.add(shape2);
            oShapes.add(shape3);
        }
        catch (Exception e) {
            e.printStackTrace(log);
        }
        log.println("Forms after adding controls : ");
        formNames = forms.getElementNames();
        for (int i = 0; i < formNames.length; ++i) {
            log.println("    '" + formNames[i] + "'");
        }
        try {
            log.println("Elements in the 'MyForm' :");
            XIndexAccess formElements1 = UnoRuntime.queryInterface(XIndexAccess.class, forms.getByName("MyForm"));
            for (int i = 0; i < formElements1.getCount(); ++i) {
                elemName = UnoRuntime.queryInterface(XNamed.class, formElements1.getByIndex(i));
                log.println("   '" + elemName.getName() + "'");
            }
        }
        catch (Exception e) {
            e.printStackTrace(log);
        }
        formLoader.load();
        try {
            oObj = (XForm)AnyConverter.toObject((Type)new Type(XForm.class), (Object)FormTools.getForms(WriterTools.getDrawPage(this.xTextDoc)).getByName("MyForm"));
            XPropertySet xSetProp = UnoRuntime.queryInterface(XPropertySet.class, (Object)oObj);
            connection = (XConnection)AnyConverter.toObject((Type)new Type(XConnection.class), (Object)xSetProp.getPropertyValue("ActiveConnection"));
        }
        catch (com.sun.star.uno.Exception e) {
            log.println("Couldn't get Form");
            e.printStackTrace(log);
        }
        oInstance = FormTools.createControl(this.xTextDoc, "TextField");
        log.println("creating a new environment for drawpage object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        this.conn = connection;
        XControlModel the_Model = shape2.getControl();
        XControlAccess the_access = UnoRuntime.queryInterface(XControlAccess.class, (Object)this.xTextDoc.getCurrentController());
        XControl cntrl = null;
        try {
            cntrl = the_access.getControl(the_Model);
            log.println(cntrl.getClass().getName());
        }
        catch (NoSuchElementException e) {
            log.println("Couldn't get OEditControl");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get OEditControl", e);
        }
        XResultSet the_set = UnoRuntime.queryInterface(XResultSet.class, (Object)oObj);
        try {
            the_set.first();
        }
        catch (com.sun.star.sdbc.SQLException e) {
            log.println("Cann't move cursor to the first row.");
            e.printStackTrace();
            throw new StatusException("Can't move cursor to the first row.", e);
        }
        tEnv.addObjRelation("Model1", shape1.getControl());
        tEnv.addObjRelation("Model2", shape2.getControl());
        log.println("adding oInstace as obj relation to environment");
        tEnv.addObjRelation("INSTANCE", oInstance);
        log.println("adding INDEX as obj relation to environment");
        tEnv.addObjRelation("INDEX", "0");
        log.println("adding NameReplaceIndex as obj relation to environment");
        tEnv.addObjRelation("XNameReplaceINDEX", "2");
        log.println("adding INSTANCEn as obj relation to environment");
        String tc = (String)Param.get("THRCNT");
        int THRCNT = 1;
        if (tc != null) {
            THRCNT = Integer.parseInt(tc);
        }
        for (int n = 1; n < 2 * (THRCNT + 1); ++n) {
            log.println("adding INSTANCE" + n + " as obj relation to environment");
            tEnv.addObjRelation("INSTANCE" + n, FormTools.createControl(this.xTextDoc, "CheckBox"));
        }
        tEnv.addObjRelation("XNameContainer.AllowDuplicateNames", new Object());
        tEnv.addObjRelation("OBJNAME", "stardiv.one.form.component.Form");
        if (the_set != null) {
            log.println("The Form has a not empty ResultSet");
        }
        final XResultSet xResSet = UnoRuntime.queryInterface(XResultSet.class, (Object)oObj);
        final XResultSetUpdate xResSetUpdate = UnoRuntime.queryInterface(XResultSetUpdate.class, (Object)oObj);
        final XRowSet xRowSet = UnoRuntime.queryInterface(XRowSet.class, (Object)oObj);
        final PrintWriter logF = log;
        tEnv.addObjRelation("XRowSetApproveBroadcaster.ApproveChecker", new _XRowSetApproveBroadcaster.RowSetApproveChecker(){

            @Override
            public void moveCursor() {
                try {
                    xResSet.beforeFirst();
                    xResSet.afterLast();
                }
                catch (com.sun.star.sdbc.SQLException e) {
                    logF.println("### _XRowSetApproveBroadcaster.RowSetApproveChecker.moveCursor() :");
                    e.printStackTrace(logF);
                }
            }

            @Override
            public RowChangeEvent changeRow() {
                try {
                    xResSet.first();
                    XRowUpdate row = UnoRuntime.queryInterface(XRowUpdate.class, (Object)xResSet);
                    row.updateString(1, "1");
                    xResSetUpdate.updateRow();
                }
                catch (com.sun.star.sdbc.SQLException e) {
                    logF.println("### _XRowSetApproveBroadcaster.RowSetApproveChecker.changeRow() :");
                    e.printStackTrace(logF);
                }
                RowChangeEvent ev = new RowChangeEvent();
                ev.Action = 2;
                ev.Rows = 1;
                return ev;
            }

            @Override
            public void changeRowSet() {
                try {
                    xRowSet.execute();
                }
                catch (com.sun.star.sdbc.SQLException e) {
                    logF.println("### _XRowSetApproveBroadcaster.RowSetApproveChecker.changeRowSet() :");
                    e.printStackTrace(logF);
                }
            }
        });
        tEnv.addObjRelation("XColumnLocate.ColumnName", "_TEXT");
        Vector<Object> params = new Vector<Object>();
        params.add(new String("SAU99"));
        params.add(new Boolean(false));
        params.add(new Byte(123));
        params.add(new Short(234));
        params.add(new Integer(12345));
        params.add(new Long(23456L));
        params.add(new Float(1.234));
        params.add(new Double(2.345));
        params.add(new byte[]{1, 2, 3});
        Date d = new Date();
        d.Day = (short)26;
        d.Month = 1;
        d.Year = (short)2001;
        params.add(d);
        Time t = new Time();
        t.Hours = 1;
        t.HundredthSeconds = (short)12;
        t.Minutes = (short)25;
        t.Seconds = (short)14;
        params.add(t);
        DateTime dt = new DateTime();
        dt.Day = (short)26;
        dt.Month = 1;
        dt.Year = (short)2001;
        dt.Hours = 1;
        dt.HundredthSeconds = (short)12;
        dt.Minutes = (short)25;
        dt.Seconds = (short)14;
        params.add(dt);
        tEnv.addObjRelation("XParameters.ParamValues", params);
        tEnv.addObjRelation("InteractionHandlerChecker", new InteractionHandlerImpl());
        tEnv.addObjRelation("CheckWarningsSupplier", new Boolean(this.isMySQLDB));
        tEnv.addObjRelation("ParameterListenerChecker", new ParameterListenerImpl());
        XPropertySet xSetProp = UnoRuntime.queryInterface(XPropertySet.class, (Object)oObj);
        try {
            xSetProp.setPropertyValue("DataSourceName", dbSourceName);
            if (this.isMySQLDB) {
                xSetProp.setPropertyValue("Command", "SELECT Column0  FROM soffice_test_table  WHERE ( (  Column0 = :param1 ) )");
            } else {
                xSetProp.setPropertyValue("Command", "SELECT \"_TEXT\" FROM \"ODatabaseForm_tmp0\" WHERE ( ( \"_TEXT\" = :param1 ) )");
            }
            xSetProp.setPropertyValue("CommandType", new Integer(2));
        }
        catch (Exception e) {
            // empty catch block
        }
        final XRowUpdate xRowUpdate = UnoRuntime.queryInterface(XRowUpdate.class, (Object)oObj);
        final XRow xRow = UnoRuntime.queryInterface(XRow.class, (Object)oObj);
        tEnv.addObjRelation("XResultSetUpdate.UpdateTester", new _XResultSetUpdate.UpdateTester(){
            String lastUpdate = null;

            @Override
            public int rowCount() throws com.sun.star.sdbc.SQLException {
                int prevPos = xResSet.getRow();
                xResSet.last();
                int count = xResSet.getRow();
                xResSet.absolute(prevPos);
                return count;
            }

            @Override
            public void update() throws com.sun.star.sdbc.SQLException {
                this.lastUpdate = xRow.getString(1);
                this.lastUpdate = this.lastUpdate + "_";
                xRowUpdate.updateString(1, this.lastUpdate);
            }

            @Override
            public boolean wasUpdated() throws com.sun.star.sdbc.SQLException {
                String getStr = xRow.getString(1);
                return this.lastUpdate.equals(getStr);
            }

            @Override
            public int currentRow() throws com.sun.star.sdbc.SQLException {
                return xResSet.getRow();
            }
        });
        Vector<Object> rowData = new Vector<Object>();
        for (int i = 0; i < DBTools.TST_TABLE_VALUES[0].length; ++i) {
            rowData.add(DBTools.TST_TABLE_VALUES[0][i]);
        }
        tEnv.addObjRelation("CurrentRowData", rowData);
        XRow row = UnoRuntime.queryInterface(XRow.class, (Object)oObj);
        tEnv.addObjRelation("XRowUpdate.XRow", row);
        tEnv.addObjRelation("XPropertyContainer.propertyNotRemovable", "Cycle");
        PropertyValue propVal = new PropertyValue();
        propVal.Name = "Name";
        propVal.Value = "Text since XPropertyAccess";
        tEnv.addObjRelation("XPropertyAccess.propertyToChange", propVal);
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        XCloseable closer;
        log.println("closing connection...");
        try {
            this.conn.close();
        }
        catch (com.sun.star.uno.Exception e) {
            log.println("Can't close the connection");
            e.printStackTrace(log);
        }
        catch (DisposedException e) {
            log.println("Connection was already closed. It's OK.");
        }
        log.println("closing data source...");
        try {
            closer = UnoRuntime.queryInterface(XCloseable.class, this.dbSrc);
            closer.close(true);
        }
        catch (CloseVetoException e) {
            log.println("couldn't close data source");
        }
        catch (DisposedException e) {
            log.println("couldn't close data source");
        }
        log.println("closing document...");
        try {
            closer = UnoRuntime.queryInterface(XCloseable.class, (Object)this.xTextDoc);
            closer.close(true);
        }
        catch (CloseVetoException e) {
            log.println("couldn't close document");
        }
        catch (DisposedException e) {
            log.println("couldn't close document");
        }
        log.println("revoking data source...");
        try {
            this.dbTools.revokeDB(dbSourceName);
        }
        catch (NoSuchElementException e) {
        }
        catch (com.sun.star.uno.Exception e) {
            log.println("Error while object test cleaning up :");
            e.printStackTrace(log);
            throw new StatusException("Error while object test cleaning up", e);
        }
    }

    public class InteractionHandlerImpl
    implements _XCompletedExecution.CheckInteractionHandler {
        private boolean handlerWasUsed = false;
        private PrintWriter log = new PrintWriter(System.out);

        @Override
        public boolean checkInteractionHandler() {
            return this.handlerWasUsed;
        }

        @Override
        public void handle(XInteractionRequest xInteractionRequest) {
            this.log.println("### _XCompletedExecution.InteractionHandlerImpl: handle called.");
            this.handlerWasUsed = true;
            Object o = xInteractionRequest.getRequest();
            ParametersRequest req = (ParametersRequest)o;
            XIndexAccess params = req.Parameters;
            int count = params.getCount();
            try {
                for (int i = 0; i < count; ++i) {
                    Object aObject = params.getByIndex(i);
                    Any any = (Any)aObject;
                    this.log.println("### _XCompletedExecution.InteractionHandlerImpl: Parameter " + i + ": " + params.getByIndex(i));
                    XPropertySet xProp = UnoRuntime.queryInterface(XPropertySet.class, params.getByIndex(i));
                    this.log.println("### _XCompletedExecution.InteractionHandlerImpl: Parameter Name: '" + xProp.getPropertyValue("Name") + "' is set to Value '1'");
                    xProp.setPropertyValue("Value", new Integer(1));
                    this.handlerWasUsed = true;
                }
            }
            catch (Exception eI) {
                this.log.println("### _XCompletedExecution.InteractionHandlerImpl: Exception!");
                eI.printStackTrace(this.log);
            }
        }

        @Override
        public void setLog(PrintWriter log) {
            this.log = log;
        }
    }

    public class ParameterListenerImpl
    implements _XDatabaseParameterBroadcaster.CheckParameterListener {
        boolean listenerWasCalled = false;
        PrintWriter log = new PrintWriter(System.out);

        @Override
        public boolean checkListener() {
            return this.listenerWasCalled;
        }

        @Override
        public boolean approveParameter(DatabaseParameterEvent e) {
            this.log.println("### ParameterListenerImpl: approve called.");
            XIndexAccess params = e.Parameters;
            int count = params.getCount();
            try {
                for (int i = 0; i < count; ++i) {
                    this.log.println("### _XDatabaseParameterBroadcaster.ParameterListenerImpl: Parameter " + i + ": " + params.getByIndex(i));
                    XPropertySet xProp = UnoRuntime.queryInterface(XPropertySet.class, params.getByIndex(i));
                    this.log.println("### _XDatabaseParameterBroadcaster.ParameterListenerImpl: Parameter Name: '" + xProp.getPropertyValue("Name") + "' is set to Value '1'");
                    xProp.setPropertyValue("Value", new Integer(1));
                    this.listenerWasCalled = true;
                }
            }
            catch (Exception eI) {
                this.log.println("### _XDatabaseParameterBroadcaster.ParameterListenerImpl: Exception!");
                eI.printStackTrace(this.log);
                return false;
            }
            return true;
        }

        @Override
        public void disposing(EventObject o) {
            this.log.println("### _XDatabaseParameterBroadcaster.ParameterListenerImpl: disposing");
        }

        @Override
        public void setLog(PrintWriter log) {
            this.log = log;
        }
    }
}

