/*
 * Decompiled with CFR 0.152.
 */
package mod._forms;

import com.sun.star.awt.XControlModel;
import com.sun.star.beans.NamedValue;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.drawing.XControlShape;
import com.sun.star.form.XBoundComponent;
import com.sun.star.form.XForm;
import com.sun.star.form.XLoadable;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.XDocumentDataSource;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XResultSetUpdate;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import ifc.form._XUpdateBroadcaster;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DBTools;
import util.FormTools;
import util.ValueChanger;
import util.ValueComparer;
import util.WriterTools;
import util.utils;

public class GenericModelTest
extends TestCase {
    private static XTextDocument m_xTextDoc;
    private static Object m_dbSrc;
    private static DBTools.DataSourceInfo m_srcInf;
    protected static final String m_dbSourceName = "APITestDatabase";
    protected static final String m_TestDB = "TestDB";
    private DBTools m_dbTools = null;
    private static boolean m_ConnectionColsed;
    public static String m_kindOfControl;
    public static ArrayList m_propertiesToSet;
    public static String m_ChangePropertyName;
    public static Object m_ChangePropertyValue;
    public static String m_ObjectName;
    protected static XLoadable m_XFormLoader;
    protected static XPropertySet m_XPS;
    protected static XInterface m_XCtrl;
    protected static String m_LCShape_Type;
    protected static String m_XPropertyAccess_propertyToChange;
    protected static String m_XPropertyContainer_propertyNotRemovable;
    protected static boolean debug;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        log.println("creating a textdocument");
        m_xTextDoc = WriterTools.createTextDoc((XMultiServiceFactory)tParam.getMSF());
        m_ConnectionColsed = false;
        debug = tParam.getBool("DebugIsActive");
        m_propertiesToSet.clear();
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        XCloseable closer;
        log.println("closing connection...");
        if (m_ConnectionColsed) {
            return;
        }
        try {
            XForm myForm = (XForm)AnyConverter.toObject((Type)new Type(XForm.class), (Object)FormTools.getForms(WriterTools.getDrawPage(m_xTextDoc)).getByName("Standard"));
            if (debug) {
                if (myForm == null) {
                    log.println("ERROR: could not get 'Standard' from drawpage!");
                }
                log.println("the draw page contains folowing elemtens:");
                String[] elements = FormTools.getForms(WriterTools.getDrawPage(m_xTextDoc)).getElementNames();
                for (int i = 0; i < elements.length; ++i) {
                    log.println("Element[" + i + "] :" + elements[i]);
                }
            }
            XPropertySet xSetProp = UnoRuntime.queryInterface(XPropertySet.class, (Object)myForm);
            XConnection connection = (XConnection)AnyConverter.toObject((Type)new Type(XConnection.class), (Object)xSetProp.getPropertyValue("ActiveConnection"));
            if (debug && connection == null) {
                log.println("ERROR: could not get property 'ActiveConnection' from the XForm");
            }
            connection.close();
        }
        catch (Exception e) {
            log.println("ERROR: Can't close the connection: " + e.toString());
        }
        log.println("closing data source...");
        try {
            XDocumentDataSource dataSource;
            closer = UnoRuntime.queryInterface(XCloseable.class, m_dbSrc);
            if (closer == null && (dataSource = UnoRuntime.queryInterface(XDocumentDataSource.class, m_dbSrc)) != null) {
                closer = UnoRuntime.queryInterface(XCloseable.class, (Object)dataSource.getDatabaseDocument());
            }
            if (debug && closer == null) {
                log.println("ERROR: couldn't get 'XCloseable' from DataSource");
            }
            closer.close(true);
        }
        catch (CloseVetoException e) {
            log.println("ERROR: couldn't close data source: " + e.toString());
        }
        catch (DisposedException e) {
            log.println("ERROR: couldn't close data source: " + e.toString());
        }
        catch (Exception e) {
            log.println("ERROR: couldn't close data source: " + e.toString());
        }
        log.println("disposing data source...");
        try {
            XComponent dataSourceComp = UnoRuntime.queryInterface(XComponent.class, m_dbSrc);
            dataSourceComp.dispose();
        }
        catch (Exception e) {
            log.println("couldn't dispose the data source");
        }
        log.println("closing document...");
        try {
            closer = UnoRuntime.queryInterface(XCloseable.class, (Object)m_xTextDoc);
            closer.close(true);
        }
        catch (CloseVetoException e) {
            log.println("ERROR: couldn't close document: " + e.toString());
        }
        catch (DisposedException e) {
            log.println("ERROR: couldn't close document: " + e.toString());
        }
        catch (Exception e) {
            log.println("ERROR: couldn't close document: " + e.toString());
        }
        log.println("revoking data source...");
        try {
            this.m_dbTools.revokeDB(m_dbSourceName);
        }
        catch (NoSuchElementException e) {
        }
        catch (com.sun.star.uno.Exception e) {
            log.println("ERROR: Error while object test cleaning up: " + e.toString());
        }
        m_ConnectionColsed = true;
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XControlModel oObj = null;
        XControlShape aShape = null;
        XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
        try {
            log.println("adding contol shape '" + m_kindOfControl + "'");
            aShape = FormTools.createControlShape(m_xTextDoc, 3000, 4500, 15000, 10000, m_kindOfControl);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create following control shape (m_kindOfControl): '" + m_kindOfControl + "': ", e);
        }
        WriterTools.getDrawPage(m_xTextDoc).add(aShape);
        oObj = aShape.getControl();
        log.println("Implementation name: " + utils.getImplName(oObj));
        try {
            String sourceTestDB = utils.getFullURL(utils.getFullTestDocName("TestDB/testDB.dbf"));
            String destTestDB = utils.getOfficeTemp(xMSF);
            destTestDB = utils.getFullURL(destTestDB + "testDB.dbf");
            log.println("copy '" + sourceTestDB + "' -> '" + destTestDB + "'");
            utils.copyFile(xMSF, sourceTestDB, destTestDB);
            this.m_dbTools = new DBTools(xMSF);
            String tmpDir = utils.getOfficeTemp(xMSF);
            m_srcInf = this.m_dbTools.newDataSourceInfo();
            GenericModelTest.m_srcInf.URL = "sdbc:dbase:" + DBTools.dirToUrl(tmpDir);
            log.println("data source: " + GenericModelTest.m_srcInf.URL);
            m_dbSrc = m_srcInf.getDataSourceService();
            this.m_dbTools.reRegisterDB(m_dbSourceName, m_dbSrc);
            m_XFormLoader = FormTools.bindForm(m_xTextDoc, m_dbSourceName, m_TestDB);
        }
        catch (com.sun.star.uno.Exception e) {
            log.println("!!! Can't access TestDB !!!");
            e.printStackTrace(log);
            throw new StatusException("Can't access TestDB", e);
        }
        log.println("creating a new environment for object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("OBJNAME", m_ObjectName);
        log.println("adding shape '" + m_LCShape_Type + "' for DataAwareControlModel test");
        aShape = FormTools.createControlShape(m_xTextDoc, 6000, 4500, 15000, 10000, m_LCShape_Type);
        WriterTools.getDrawPage(m_xTextDoc).add(aShape);
        m_XPS = UnoRuntime.queryInterface(XPropertySet.class, (Object)oObj);
        int i = 0;
        NamedValue prop = null;
        try {
            for (i = 0; i < m_propertiesToSet.size(); ++i) {
                prop = (NamedValue)m_propertiesToSet.get(i);
                log.println("setting property: '" + prop.Name + "' to value '" + prop.Value.toString() + "'");
                m_XPS.setPropertyValue(prop.Name, prop.Value);
            }
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't set property '" + prop.Name + "': ", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't set property '" + prop.Name + "': ", e);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't set property '" + prop.Name + "': ", e);
        }
        catch (UnknownPropertyException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't set property '" + prop.Name + "': ", e);
        }
        catch (ClassCastException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get property on index '" + i + "': ", e);
        }
        tEnv.addObjRelation("LC", aShape.getControl());
        tEnv.addObjRelation("FL", m_XFormLoader);
        m_XCtrl = oObj;
        tEnv.addObjRelation("XUpdateBroadcaster.Checker", new Checker(m_XFormLoader, m_XPS, m_XCtrl, m_ChangePropertyName, m_ChangePropertyValue));
        tEnv.addObjRelation("DataAwareControlModel.NewFieldName", "_DATE");
        tEnv.addObjRelation("PSEUDOPERSISTENT", new Boolean(true));
        HashSet<String> exclude = new HashSet<String>();
        exclude.add("FormatKey");
        tEnv.addObjRelation("XFastPropertySet.ExcludeProps", exclude);
        PropertyValue propVal = new PropertyValue();
        propVal.Name = m_XPropertyAccess_propertyToChange;
        propVal.Value = "Text since XPropertyAccess";
        tEnv.addObjRelation("XPropertyAccess.propertyToChange", propVal);
        tEnv.addObjRelation("XPropertyContainer.propertyNotRemovable", m_XPropertyContainer_propertyNotRemovable);
        return tEnv;
    }

    static {
        m_dbSrc = null;
        m_srcInf = null;
        m_ConnectionColsed = false;
        m_kindOfControl = null;
        m_propertiesToSet = new ArrayList();
        m_ChangePropertyName = null;
        m_ChangePropertyValue = null;
        m_ObjectName = null;
        m_XFormLoader = null;
        m_XPS = null;
        m_XCtrl = null;
        m_LCShape_Type = null;
        m_XPropertyAccess_propertyToChange = "HelpText";
        m_XPropertyContainer_propertyNotRemovable = "HelpText";
        debug = false;
    }

    static class Checker
    implements _XUpdateBroadcaster.UpdateChecker {
        private Object lastValue = null;
        XLoadable formLoaderF = null;
        XPropertySet ps = null;
        XInterface ctrl = null;
        String ChangePropertyName = null;
        Object ChangePropertyValue = null;

        public Checker(XLoadable xl, XPropertySet ps, XInterface ctrl, String ChangePropertyName, Object ChangePropertyValue) {
            this.formLoaderF = xl;
            this.ps = ps;
            this.ctrl = ctrl;
            this.ChangePropertyName = ChangePropertyName;
            this.ChangePropertyValue = ChangePropertyValue;
        }

        @Override
        public void update() throws com.sun.star.uno.Exception {
            if (!this.formLoaderF.isLoaded()) {
                this.formLoaderF.load();
            }
            this.lastValue = ValueChanger.changePValue(this.ps.getPropertyValue(this.ChangePropertyName));
            if (this.lastValue == null) {
                if (this.ChangePropertyValue != null) {
                    this.lastValue = this.ChangePropertyValue;
                } else {
                    String msg = "The initial value of the property '" + this.ChangePropertyName + "' is NULL\n";
                    msg = msg + "The member variable 'm_ChangePropertyValue' is NULL\n";
                    msg = msg + "Could not change Property.";
                    throw new StatusException(Status.failed(msg));
                }
            }
            this.ps.setPropertyValue(this.ChangePropertyName, this.lastValue);
        }

        @Override
        public void commit() throws SQLException {
            XBoundComponent bound = UnoRuntime.queryInterface(XBoundComponent.class, (Object)this.ctrl);
            XResultSetUpdate update = UnoRuntime.queryInterface(XResultSetUpdate.class, (Object)this.formLoaderF);
            bound.commit();
            update.updateRow();
        }

        @Override
        public boolean wasCommited() throws com.sun.star.uno.Exception {
            this.formLoaderF.reload();
            Object newValue = this.ps.getPropertyValue(this.ChangePropertyName);
            return newValue != null && ValueComparer.equalValue(this.lastValue, newValue);
        }
    }
}

