/*
 * Decompiled with CFR 0.152.
 */
package mod._dbpool;

import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;

public class OConnectionPool
extends TestCase {
    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
        XInterface oObj = null;
        try {
            oObj = (XInterface)xMSF.createInstance("com.sun.star.sdbc.ConnectionPool");
        }
        catch (Exception e) {
            throw new StatusException(Status.failed("Couldn't create instance"));
        }
        log.println("creating a new environment for object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        String dbaseURL = (String)Param.get("dbase.url");
        if (dbaseURL == null) {
            throw new StatusException(Status.failed("Couldn't get parameter 'dbase.url'"));
        }
        tEnv.addObjRelation("SDBC.URL", "sdbc:dbase:" + dbaseURL);
        String jdbcURL = (String)Param.get("jdbc.url");
        if (jdbcURL == null) {
            throw new StatusException(Status.failed("Couldn't get parameter 'jdbc.url'"));
        }
        tEnv.addObjRelation("JDBC.URL", "jdbc:" + jdbcURL);
        String jdbcUser = (String)Param.get("jdbc.user");
        if (jdbcUser == null) {
            throw new StatusException(Status.failed("Couldn't get parameter 'jdbc.user'"));
        }
        String jdbcPassword = (String)Param.get("jdbc.password");
        if (jdbcPassword == null) {
            throw new StatusException(Status.failed("Couldn't get parameter 'jdbc.password'"));
        }
        PropertyValue[] jdbcInfo = new PropertyValue[3];
        jdbcInfo[0] = new PropertyValue();
        jdbcInfo[0].Name = "user";
        jdbcInfo[0].Value = jdbcUser;
        jdbcInfo[1] = new PropertyValue();
        jdbcInfo[1].Name = "password";
        jdbcInfo[1].Value = jdbcPassword;
        jdbcInfo[2] = new PropertyValue();
        jdbcInfo[2].Name = "JavaDriverClass";
        jdbcInfo[2].Value = "org.gjt.mm.mysql.Driver";
        tEnv.addObjRelation("JDBC.INFO", jdbcInfo);
        return tEnv;
    }
}

