/*
 * Decompiled with CFR 0.152.
 */
package mod._dbaccess;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDevice;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XGraphics;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XControlShape;
import com.sun.star.form.XBoundComponent;
import com.sun.star.form.XGridColumnFactory;
import com.sun.star.form.XLoadable;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XResultSetUpdate;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.URL;
import com.sun.star.util.XCloseable;
import com.sun.star.view.XControlAccess;
import ifc.form._XUpdateBroadcaster;
import java.io.PrintWriter;
import java.util.Comparator;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.FormTools;
import util.SOfficeFactory;
import util.WriterTools;
import util.utils;

public class SbaXGridControl
extends TestCase {
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a textdocument");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        XInterface toolkit = null;
        try {
            toolkit = (XInterface)((XMultiServiceFactory)tParam.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)toolkit);
        XTopWindow atw = tk.getActiveTopWindow();
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)atw);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        XAccessibleContext button = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)44);
        XAccessibleAction action = UnoRuntime.queryInterface(XAccessibleAction.class, (Object)button);
        try {
            action.doAccessibleAction(0);
        }
        catch (IndexOutOfBoundsException iob) {
            log.println("couldn't close dialog");
        }
        catch (DisposedException e) {
            log.println("couldn't close dialog");
        }
        log.println("    disposing xTextDoc ");
        try {
            XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, (Object)this.xTextDoc);
            closer.close(true);
        }
        catch (CloseVetoException e) {
            log.println("couldn't close document");
        }
        catch (DisposedException e) {
            log.println("couldn't close document");
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XControl oObj = null;
        XWindowPeer the_win = null;
        XToolkit the_kit = null;
        XDevice aDevice = null;
        XGraphics aGraphic = null;
        XPropertySet aControl = null;
        XPropertySet aControl2 = null;
        XPropertySet aControl3 = null;
        XPropertySet aControl4 = null;
        XGridColumnFactory columns = null;
        XControlShape aShape = SbaXGridControl.createGrid(this.xTextDoc, 3000, 4500, 15000, 10000);
        XControlModel the_Model = aShape.getControl();
        WriterTools.getDrawPage(this.xTextDoc).add(aShape);
        XLoadable formLoader = FormTools.bindForm(this.xTextDoc);
        XControlAccess the_access = UnoRuntime.queryInterface(XControlAccess.class, (Object)this.xTextDoc.getCurrentController());
        try {
            columns = UnoRuntime.queryInterface(XGridColumnFactory.class, (Object)the_Model);
            aControl = columns.createColumn("TextField");
            aControl.setPropertyValue("DataField", "Identifier");
            aControl.setPropertyValue("Label", "Identifier");
            aControl2 = columns.createColumn("TextField");
            aControl2.setPropertyValue("DataField", "Publisher");
            aControl2.setPropertyValue("Label", "Publisher");
            aControl3 = columns.createColumn("TextField");
            aControl3.setPropertyValue("DataField", "Author");
            aControl3.setPropertyValue("Label", "Author");
            aControl4 = columns.createColumn("TextField");
            aControl4.setPropertyValue("DataField", "Title");
            aControl4.setPropertyValue("Label", "Title");
        }
        catch (IllegalArgumentException e) {
            log.println("!!! Couldn't create instance : " + e);
            throw new StatusException("Can't create column instances.", e);
        }
        catch (WrappedTargetException e) {
            log.println("!!! Couldn't create instance : " + e);
            throw new StatusException("Can't create column instances.", e);
        }
        catch (PropertyVetoException e) {
            log.println("!!! Couldn't create instance : " + e);
            throw new StatusException("Can't create column instances.", e);
        }
        catch (UnknownPropertyException e) {
            log.println("!!! Couldn't create instance : " + e);
            throw new StatusException("Can't create column instances.", e);
        }
        XNameContainer aContainer = UnoRuntime.queryInterface(XNameContainer.class, (Object)the_Model);
        try {
            aContainer.insertByName("First", aControl);
            aContainer.insertByName("Second", aControl2);
        }
        catch (Exception e) {
            log.println("!!! Could't insert column Instance");
            e.printStackTrace(log);
            throw new StatusException("Can't insert columns", e);
        }
        try {
            oObj = the_access.getControl(the_Model);
            the_win = the_access.getControl(the_Model).getPeer();
            the_kit = the_win.getToolkit();
            aDevice = the_kit.createScreenCompatibleDevice(200, 200);
            aGraphic = aDevice.createGraphics();
        }
        catch (Exception e) {
            log.println("Couldn't get GridControl");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get GridControl", e);
        }
        aShape = FormTools.createControlShape(this.xTextDoc, 3000, 4500, 15000, 10000, "TextField");
        WriterTools.getDrawPage(this.xTextDoc).add(aShape);
        the_Model = aShape.getControl();
        the_access = UnoRuntime.queryInterface(XControlAccess.class, (Object)this.xTextDoc.getCurrentController());
        XWindow win = null;
        XControl cntrl = null;
        try {
            cntrl = the_access.getControl(the_Model);
            win = UnoRuntime.queryInterface(XWindow.class, (Object)cntrl);
        }
        catch (Exception e) {
            log.println("Couldn't get Control");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get Control", e);
        }
        log.println("creating a new environment for object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("Selections", new Object[]{new Object[]{new Integer(0)}, new Object[]{new Integer(1)}});
        tEnv.addObjRelation("Comparer", new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Integer)o1).compareTo((Integer)o2);
            }

            @Override
            public boolean equals(Object obj) {
                return this.compare(this, obj) == 0;
            }
        });
        tEnv.addObjRelation("XContainer.Container", aContainer);
        tEnv.addObjRelation("INSTANCE", aControl3);
        tEnv.addObjRelation("INSTANCE2", aControl4);
        tEnv.addObjRelation("GRAPHICS", aGraphic);
        tEnv.addObjRelation("CONTEXT", this.xTextDoc);
        tEnv.addObjRelation("WINPEER", the_win);
        tEnv.addObjRelation("TOOLKIT", the_kit);
        tEnv.addObjRelation("MODEL", the_Model);
        tEnv.addObjRelation("XWindow.AnotherWindow", win);
        URL url = new URL();
        url.Complete = ".uno:FormSlots/moveToNext";
        tEnv.addObjRelation("XDispatch.URL", url);
        log.println("ImplName: " + utils.getImplName(oObj));
        FormTools.switchDesignOf((XMultiServiceFactory)Param.getMSF(), this.xTextDoc);
        final XControl ctrl = oObj;
        final XLoadable formLoaderF = formLoader;
        final XPropertySet ps = UnoRuntime.queryInterface(XPropertySet.class, (Object)aControl2);
        tEnv.addObjRelation("XUpdateBroadcaster.Checker", new _XUpdateBroadcaster.UpdateChecker(){
            private String lastText = "";

            @Override
            public void update() throws Exception {
                if (!formLoaderF.isLoaded()) {
                    formLoaderF.load();
                }
                this.lastText = "_" + ps.getPropertyValue("Text");
                ps.setPropertyValue("Text", this.lastText);
            }

            @Override
            public void commit() throws SQLException {
                XBoundComponent bound = UnoRuntime.queryInterface(XBoundComponent.class, (Object)ctrl);
                XResultSetUpdate update = UnoRuntime.queryInterface(XResultSetUpdate.class, (Object)formLoaderF);
                bound.commit();
                update.updateRow();
            }

            @Override
            public boolean wasCommited() throws Exception {
                String getS = (String)ps.getPropertyValue("Text");
                return this.lastText.equals(getS);
            }
        });
        return tEnv;
    }

    public static XControlShape createGrid(XComponent oDoc, int height, int width, int x, int y) {
        Size size = new Size();
        Point position = new Point();
        XControlShape oCShape = null;
        XControlModel aControl = null;
        XMultiServiceFactory oDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)oDoc);
        try {
            Object oInt = oDocMSF.createInstance("com.sun.star.drawing.ControlShape");
            Object aCon = oDocMSF.createInstance("com.sun.star.form.component.GridControl");
            XPropertySet model_props = UnoRuntime.queryInterface(XPropertySet.class, aCon);
            model_props.setPropertyValue("DefaultControl", "com.sun.star.form.control.InteractionGridControl");
            aControl = UnoRuntime.queryInterface(XControlModel.class, aCon);
            oCShape = UnoRuntime.queryInterface(XControlShape.class, oInt);
            size.Height = height;
            size.Width = width;
            position.X = x;
            position.Y = y;
            oCShape.setSize(size);
            oCShape.setPosition(position);
        }
        catch (Exception e) {
            System.out.println("Couldn't create Grid" + e);
            throw new StatusException("Couldn't create Grid", e);
        }
        oCShape.setControl(aControl);
        return oCShape;
    }
}

