/*
 * Decompiled with CFR 0.152.
 */
package mod._dbaccess;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.ParametersRequest;
import com.sun.star.sdb.RowChangeEvent;
import com.sun.star.sdb.XInteractionSupplyParameters;
import com.sun.star.sdbc.XCloseable;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XResultSetUpdate;
import com.sun.star.sdbc.XRow;
import com.sun.star.sdbc.XRowSet;
import com.sun.star.sdbc.XRowUpdate;
import com.sun.star.task.XInteractionAbort;
import com.sun.star.task.XInteractionContinuation;
import com.sun.star.task.XInteractionRequest;
import com.sun.star.ucb.AuthenticationRequest;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.sdb._XCompletedExecution;
import ifc.sdb._XRowSetApproveBroadcaster;
import ifc.sdbc._XResultSetUpdate;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Vector;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DBTools;
import util.utils;

public class ORowSet
extends TestCase {
    private static int uniqueSuffix = 0;
    private DBTools dbTools = null;
    private static String origDB = null;
    private PrintWriter log = null;
    private static String tmpDir = null;
    String tableName = null;
    DBTools.DataSourceInfo srcInf = null;
    boolean isMySQLDB = false;
    protected static final String dbSourceName = "ORowSetDataSource";
    public XConnection conn = null;
    Object dbSrc = null;
    String aFile = "";

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) throws StatusException {
        this.log = log;
        tmpDir = (String)Param.get("TMPURL");
        tmpDir = utils.getOfficeTemp((XMultiServiceFactory)Param.getMSF());
        origDB = utils.getFullTestDocName("TestDB/testDB.dbf");
        this.dbTools = new DBTools((XMultiServiceFactory)Param.getMSF());
        String dbURL = (String)Param.get("test.db.url");
        String dbUser = (String)Param.get("test.db.user");
        String dbPassword = (String)Param.get("test.db.password");
        log.println("Creating and registering DataSource ...");
        this.srcInf = this.dbTools.newDataSourceInfo();
        if (dbURL != null && dbUser != null && dbPassword != null) {
            this.isMySQLDB = true;
            log.println("dbURL = " + dbURL);
            log.println("dbUSER = " + dbUser);
            log.println("dbPASSWORD = " + dbPassword);
            try {
                this.tableName = "soffice_test_table";
                this.srcInf.URL = "jdbc:" + dbURL;
                this.srcInf.IsPasswordRequired = new Boolean(true);
                this.srcInf.Password = dbPassword;
                this.srcInf.User = dbUser;
                PropertyValue[] propInfo = new PropertyValue[]{new PropertyValue()};
                propInfo[0].Name = "JavaDriverClass";
                propInfo[0].Value = "org.gjt.mm.mysql.Driver";
                this.srcInf.Info = propInfo;
                this.dbSrc = this.srcInf.getDataSourceService();
                if (uniqueSuffix < 1) {
                    this.dbTools.reRegisterDB(dbSourceName, this.dbSrc);
                }
                XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
                this.aFile = utils.getOfficeTemp(xMSF) + dbSourceName + ".odb";
            }
            catch (com.sun.star.uno.Exception e) {
                log.println("Error while object test initialization :");
                e.printStackTrace(log);
                throw new StatusException("Error while object test initialization", e);
            }
        }
        try {
            this.srcInf.URL = "sdbc:dbase:" + DBTools.dirToUrl(tmpDir);
            this.dbSrc = this.srcInf.getDataSourceService();
            if (uniqueSuffix < 1) {
                this.dbTools.reRegisterDB(dbSourceName, this.dbSrc);
            }
        }
        catch (com.sun.star.uno.Exception e) {
            log.println("Error while object test initialization :");
            e.printStackTrace(log);
            throw new StatusException("Error while object test initialization", e);
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        Object oInterface = null;
        XMultiServiceFactory xMSF = null;
        ++uniqueSuffix;
        boolean envCreatedOK = false;
        if (this.isMySQLDB) {
            try {
                this.dbTools.initTestTableUsingJDBC(this.tableName, this.srcInf);
            }
            catch (SQLException e) {
                e.printStackTrace(log);
                throw new StatusException(Status.failed("Couldn't  init test table. SQLException..."));
            }
            catch (ClassNotFoundException e) {
                throw new StatusException(Status.failed("Couldn't register mysql driver"));
            }
        } else {
            String oldF = null;
            String newF = null;
            do {
                this.tableName = "ORowSet_tmp" + uniqueSuffix;
                oldF = utils.getFullURL(origDB);
                newF = utils.getOfficeTemp((XMultiServiceFactory)Param.getMSF()) + this.tableName + ".dbf";
            } while (!utils.overwriteFile((XMultiServiceFactory)Param.getMSF(), oldF, newF) && uniqueSuffix++ < 50);
        }
        XCloseable connection = null;
        try {
            xMSF = (XMultiServiceFactory)Param.getMSF();
            Object oRowSet = xMSF.createInstance("com.sun.star.sdb.RowSet");
            XPropertySet xSetProp = UnoRuntime.queryInterface(XPropertySet.class, oRowSet);
            log.println("Trying to open: " + this.tableName);
            xSetProp.setPropertyValue("DataSourceName", dbSourceName);
            xSetProp.setPropertyValue("Command", this.tableName);
            xSetProp.setPropertyValue("CommandType", new Integer(0));
            XRowSet xORowSet = UnoRuntime.queryInterface(XRowSet.class, oRowSet);
            xORowSet.execute();
            connection = null;
            try {
                connection = (XConnection)AnyConverter.toObject((Type)new Type(XConnection.class), (Object)xSetProp.getPropertyValue("ActiveConnection"));
            }
            catch (IllegalArgumentException iae) {
                throw new StatusException("couldn't convert Any", iae);
            }
            oInterface = oRowSet;
            XResultSet xRes = UnoRuntime.queryInterface(XResultSet.class, oRowSet);
            xRes.first();
            if (oInterface == null) {
                log.println("Service wasn't created");
                throw new StatusException("Service wasn't created", new NullPointerException());
            }
            oObj = (XInterface)oInterface;
            log.println("    creating a new environment for object");
            TestEnvironment tEnv = new TestEnvironment(oObj);
            tEnv.addObjRelation("ORowSet.Connection", connection);
            this.conn = (XConnection)tEnv.getObjRelation("ORowSet.Connection");
            final XResultSet xResSet = UnoRuntime.queryInterface(XResultSet.class, (Object)oObj);
            final XResultSetUpdate xResSetUpdate = UnoRuntime.queryInterface(XResultSetUpdate.class, (Object)oObj);
            final XRowSet xRowSet = UnoRuntime.queryInterface(XRowSet.class, (Object)oObj);
            final XRowUpdate xRowUpdate = UnoRuntime.queryInterface(XRowUpdate.class, (Object)oObj);
            final PrintWriter logF = log;
            tEnv.addObjRelation("XRowSetApproveBroadcaster.ApproveChecker", new _XRowSetApproveBroadcaster.RowSetApproveChecker(){

                @Override
                public void moveCursor() {
                    try {
                        xResSet.beforeFirst();
                        xResSet.afterLast();
                        xResSet.first();
                    }
                    catch (com.sun.star.sdbc.SQLException e) {
                        logF.println("### _XRowSetApproveBroadcaster.RowSetApproveChecker.moveCursor() :");
                        e.printStackTrace(logF);
                    }
                }

                @Override
                public RowChangeEvent changeRow() {
                    try {
                        xResSet.first();
                        xRowUpdate.updateString(1, "ORowSetTest2");
                        xResSetUpdate.updateRow();
                    }
                    catch (com.sun.star.sdbc.SQLException e) {
                        logF.println("### _XRowSetApproveBroadcaster.RowSetApproveChecker.changeRow() :");
                        e.printStackTrace(logF);
                    }
                    RowChangeEvent ev = new RowChangeEvent();
                    ev.Action = 2;
                    ev.Rows = 1;
                    return ev;
                }

                @Override
                public void changeRowSet() {
                    try {
                        xRowSet.execute();
                        xResSet.first();
                    }
                    catch (com.sun.star.sdbc.SQLException e) {
                        logF.println("### _XRowSetApproveBroadcaster.RowSetApproveChecker.changeRowSet() :");
                        e.printStackTrace(logF);
                    }
                }
            });
            Vector<Object> rowData = new Vector<Object>();
            for (int i = 0; i < DBTools.TST_TABLE_VALUES[0].length; ++i) {
                rowData.add(DBTools.TST_TABLE_VALUES[0][i]);
            }
            tEnv.addObjRelation("CurrentRowData", rowData);
            tEnv.addObjRelation("XColumnLocate.ColumnName", "_TEXT");
            tEnv.addObjRelation("InteractionHandlerChecker", new InteractionHandlerImpl());
            XPropertySet xProp = UnoRuntime.queryInterface(XPropertySet.class, (Object)oObj);
            try {
                xProp.setPropertyValue("DataSourceName", dbSourceName);
                if (this.isMySQLDB) {
                    xProp.setPropertyValue("Command", "SELECT Column0  FROM soffice_test_table  WHERE ( (  Column0 = :param1 ) )");
                } else {
                    xProp.setPropertyValue("Command", "SELECT \"_TEXT\" FROM \"ORowSet_tmp" + uniqueSuffix + "\" WHERE ( ( \"_TEXT\" = :param1 ) )");
                }
                xProp.setPropertyValue("CommandType", new Integer(2));
            }
            catch (Exception e) {
                // empty catch block
            }
            Vector params = new Vector();
            tEnv.addObjRelation("XParameters.ParamValues", params);
            XRow row = UnoRuntime.queryInterface(XRow.class, (Object)oObj);
            tEnv.addObjRelation("XRowUpdate.XRow", row);
            final XResultSet xResSet2 = UnoRuntime.queryInterface(XResultSet.class, (Object)oObj);
            final XRowUpdate xRowUpdate2 = UnoRuntime.queryInterface(XRowUpdate.class, (Object)oObj);
            final XRow xRow = UnoRuntime.queryInterface(XRow.class, (Object)oObj);
            tEnv.addObjRelation("XResultSetUpdate.UpdateTester", new _XResultSetUpdate.UpdateTester(){
                String lastUpdate = null;

                @Override
                public int rowCount() throws com.sun.star.sdbc.SQLException {
                    int prevPos = xResSet2.getRow();
                    xResSet2.last();
                    int count = xResSet2.getRow();
                    xResSet2.absolute(prevPos);
                    return count;
                }

                @Override
                public void update() throws com.sun.star.sdbc.SQLException {
                    this.lastUpdate = xRow.getString(1);
                    this.lastUpdate = this.lastUpdate + "_";
                    xRowUpdate2.updateString(1, this.lastUpdate);
                }

                @Override
                public boolean wasUpdated() throws com.sun.star.sdbc.SQLException {
                    String getStr = xRow.getString(1);
                    return this.lastUpdate.equals(getStr);
                }

                @Override
                public int currentRow() throws com.sun.star.sdbc.SQLException {
                    return xResSet2.getRow();
                }
            });
            envCreatedOK = true;
            TestEnvironment testEnvironment = tEnv;
            return testEnvironment;
        }
        catch (com.sun.star.uno.Exception e) {
            log.println("Can't create object");
            e.printStackTrace(log);
            try {
                connection.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new StatusException("Can't create object", e);
        }
        finally {
            if (!envCreatedOK) {
                try {
                    connection.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        try {
            this.conn.close();
            XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
            Object sfa = xMSF.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
            XSimpleFileAccess xSFA = UnoRuntime.queryInterface(XSimpleFileAccess.class, sfa);
            log.println("deleting database file");
            xSFA.kill(this.aFile);
            log.println("Could delete file " + this.aFile + ": " + !xSFA.exists(this.aFile));
        }
        catch (com.sun.star.uno.Exception e) {
            log.println("Can't close the connection");
            e.printStackTrace(log);
        }
        catch (DisposedException e) {
            log.println("Connection was already closed. It's OK.");
        }
    }

    public class InteractionHandlerImpl
    implements _XCompletedExecution.CheckInteractionHandler {
        private boolean handlerWasUsed = false;
        private PrintWriter log = new PrintWriter(System.out);

        @Override
        public boolean checkInteractionHandler() {
            return this.handlerWasUsed;
        }

        @Override
        public void handle(XInteractionRequest xInteractionRequest) {
            this.log.println("### _XCompletedExecution.InteractionHandlerImpl: handle called.");
            ParametersRequest req = null;
            boolean abort = false;
            Object o = xInteractionRequest.getRequest();
            if (o instanceof ParametersRequest) {
                req = (ParametersRequest)o;
            } else if (o instanceof AuthenticationRequest) {
                this.log.println("### The request in XCompletedExecution is of type 'AuthenticationRequest'");
                this.log.println("### This is not implemented in ORowSet.InteractionHandlerImpl test -> abort.");
                abort = true;
            } else {
                this.log.println("### Unknown request:" + o.toString());
                this.log.println("### This is not implemented in ORowSet.InteractionHandlerImpl test -> abort.");
                abort = true;
            }
            XInteractionContinuation[] xCont = xInteractionRequest.getContinuations();
            XInteractionSupplyParameters xParamCallback = null;
            for (int i = 0; i < xCont.length; ++i) {
                if (abort) {
                    XInteractionAbort xAbort = null;
                    xAbort = UnoRuntime.queryInterface(XInteractionAbort.class, (Object)xCont[i]);
                    if (xAbort != null) {
                        xAbort.select();
                    }
                    return;
                }
                xParamCallback = UnoRuntime.queryInterface(XInteractionSupplyParameters.class, (Object)xCont[i]);
                if (xParamCallback != null) break;
            }
            if (xParamCallback != null) {
                this.log.println("### _XCompletedExecution.InteractionHandlerImpl: supplying parameters.");
                this.handlerWasUsed = true;
                PropertyValue[] prop = new PropertyValue[]{new PropertyValue()};
                prop[0].Name = "param1";
                prop[0].Value = "Hi.";
                xParamCallback.setParameters(prop);
                xParamCallback.select();
            } else {
                this.log.println("### _XCompletedExecution.InteractionHandlerImpl: Got no 'XInteractionSupplyParameters' and no 'XInteractionAbort'.");
            }
        }

        @Override
        public void setLog(PrintWriter log) {
            this.log = log;
        }
    }
}

