/*
 * Decompiled with CFR 0.152.
 */
package mod._dbaccess;

import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.drawing.XControlShape;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.URL;
import com.sun.star.util.XCloseable;
import com.sun.star.view.XControlAccess;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FormTools;
import util.SOfficeFactory;
import util.WriterTools;

public class ODatasourceBrowser
extends TestCase {
    XDesktop the_Desk;
    XTextDocument xTextDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        this.the_Desk = UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)Param.getMSF()));
        System.setProperty("hideMe", "false");
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xTextDoc");
        System.setProperty("hideMe", "true");
        if (this.xTextDoc != null) {
            log.println("    disposing xTextDoc ");
            try {
                XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, (Object)this.xTextDoc);
                closer.close(true);
            }
            catch (CloseVetoException e) {
                log.println("couldn't close document");
            }
            catch (DisposedException e) {
                log.println("couldn't close document");
            }
        }
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        log.println("creating a test environment");
        if (this.xTextDoc != null) {
            log.println("    disposing xTextDoc ");
            try {
                XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, (Object)this.xTextDoc);
                closer.close(true);
            }
            catch (CloseVetoException e) {
                log.println("couldn't close document");
            }
            catch (DisposedException e) {
                log.println("couldn't close document");
            }
        }
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a text document");
            this.xTextDoc = SOF.createTextDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        this.shortWait();
        XModel aModel1 = UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
        XController secondController = aModel1.getCurrentController();
        XFrame the_frame1 = this.the_Desk.getCurrentFrame();
        if (the_frame1 == null) {
            log.println("Current frame was not found !!!");
        }
        XDispatchProvider aProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)the_frame1);
        XDispatch getting = null;
        log.println("opening DatasourceBrowser");
        URL the_url = new URL();
        the_url.Complete = ".component:DB/DataSourceBrowser";
        getting = aProv.queryDispatch(the_url, "_beamer", 12);
        PropertyValue[] noArgs = new PropertyValue[]{};
        getting.dispatch(the_url, noArgs);
        XFrame the_frame2 = the_frame1.findFrame("_beamer", 4);
        the_frame2.setName("DatasourceBrowser");
        XController oObj = the_frame2.getController();
        Object[] params = new Object[3];
        PropertyValue param1 = new PropertyValue();
        param1.Name = "DataSourceName";
        param1.Value = "Bibliography";
        params[0] = param1;
        PropertyValue param2 = new PropertyValue();
        param2.Name = "CommandType";
        param2.Value = new Integer(0);
        params[1] = param2;
        PropertyValue param3 = new PropertyValue();
        param3.Name = "Command";
        param3.Value = "biblio";
        params[2] = param3;
        try {
            XInitialization xInit = UnoRuntime.queryInterface(XInitialization.class, (Object)oObj);
            xInit.initialize(params);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't initialize document", e);
        }
        this.shortWait();
        XControlShape aShape = FormTools.createControlShape(this.xTextDoc, 3000, 4500, 15000, 10000, "CommandButton");
        WriterTools.getDrawPage(this.xTextDoc).add(aShape);
        XControlModel shapeModel = aShape.getControl();
        XControlAccess xCtrlAccess = UnoRuntime.queryInterface(XControlAccess.class, (Object)secondController);
        XControl xCtrl = null;
        try {
            xCtrl = xCtrlAccess.getControl(shapeModel);
        }
        catch (Exception e) {
            e.printStackTrace(log);
        }
        XWindow docWindow = UnoRuntime.queryInterface(XWindow.class, (Object)xCtrl);
        log.println("creating a new environment for ODatasourceBrowser object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("XInitialization.args", params);
        tEnv.addObjRelation("Frame", the_frame1);
        tEnv.addObjRelation("SecondModel", aModel1);
        tEnv.addObjRelation("otherWindow", docWindow);
        tEnv.addObjRelation("SecondController", secondController);
        tEnv.addObjRelation("HasViewData", new Boolean(false));
        tEnv.addObjRelation("XDispatchProvider.URL", ".uno:DataSourceBrowser/FormLetter");
        return tEnv;
    }

    private void shortWait() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            System.out.println("While waiting :" + e);
        }
    }
}

