/*
 * Decompiled with CFR 0.152.
 */
package mod._dbaccess;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.XOfficeDatabaseDocument;
import com.sun.star.sdbc.XDataSource;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.XNamingService;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.utils;

public class ODatabaseSource
extends TestCase {
    private static int uniqueSuffixStat = 0;
    private int uniqueSuffix = 0;
    private XNamingService xDBContextNameServ = null;
    private String databaseName = null;
    private XOfficeDatabaseDocument xDBDoc = null;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        this.uniqueSuffix = uniqueSuffixStat++;
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing not longer needed docs... ");
        DesktopTools.closeDoc(this.xDBDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XDataSource oObj = null;
        Object oInterface = null;
        XMultiServiceFactory xMSF = null;
        xMSF = (XMultiServiceFactory)Param.getMSF();
        try {
            oInterface = xMSF.createInstance("com.sun.star.sdb.DatabaseContext");
            if (oInterface == null) {
                throw new StatusException("Could not get service 'com.sun.star.sdb.DatabaseContext'", new Exception());
            }
        }
        catch (Exception e) {
            log.println("Could not get service 'com.sun.star.sdb.DatabaseContext'");
            e.printStackTrace();
            throw new StatusException("Service not available", e);
        }
        this.xDBContextNameServ = UnoRuntime.queryInterface(XNamingService.class, oInterface);
        String tmpDatabaseUrl = utils.getOfficeTempDir((XMultiServiceFactory)Param.getMSF());
        tmpDatabaseUrl = "sdbc:dbase:file:///" + tmpDatabaseUrl;
        try {
            XInterface oDatabaseDoc = (XInterface)xMSF.createInstance("com.sun.star.sdb.OfficeDatabaseDocument");
            if (oDatabaseDoc == null) {
                throw new StatusException("Could not get service 'com.sun.star.sdb.OfficeDatabaseDocument'", new Exception());
            }
            this.xDBDoc = UnoRuntime.queryInterface(XOfficeDatabaseDocument.class, (Object)oDatabaseDoc);
        }
        catch (Exception e) {
            log.println("Could not get service 'com.sun.star.sdb.OfficeDatabaseDocument'");
            e.printStackTrace();
            throw new StatusException("Service not available", e);
        }
        oObj = this.xDBDoc.getDataSource();
        log.println("ImplementationName: " + utils.getImplName(oObj));
        XPropertySet xSrcProp = UnoRuntime.queryInterface(XPropertySet.class, (Object)oObj);
        try {
            xSrcProp.setPropertyValue("URL", tmpDatabaseUrl);
        }
        catch (UnknownPropertyException e) {
            throw new StatusException("Could not set property 'URL' ", e);
        }
        catch (PropertyVetoException e) {
            throw new StatusException("Could not set property 'URL' ", e);
        }
        catch (IllegalArgumentException e) {
            throw new StatusException("Could not set property 'URL' ", e);
        }
        catch (WrappedTargetException e) {
            throw new StatusException("Could not set property 'URL' ", e);
        }
        this.databaseName = "NewDatabaseSource" + this.uniqueSuffix;
        try {
            this.xDBContextNameServ.revokeObject(this.databaseName);
        }
        catch (Exception e) {
            log.println("Nothing to be removed - OK");
        }
        XStorable store = UnoRuntime.queryInterface(XStorable.class, (Object)this.xDBDoc);
        String aFile = utils.getOfficeTemp((XMultiServiceFactory)Param.getMSF()) + "DataSource.odb";
        try {
            store.storeAsURL(aFile, new PropertyValue[0]);
        }
        catch (IOException e) {
            log.println("Could not store datasource 'aFile'");
            e.printStackTrace();
            throw new StatusException("Could not save ", e);
        }
        catch (Exception e) {
            log.println("Could not store datasource 'aFile'");
            e.printStackTrace();
            throw new StatusException("Could not save ", e);
        }
        try {
            this.xDBContextNameServ.registerObject(this.databaseName, oObj);
        }
        catch (Exception e) {
            log.println("Could not register data source");
            e.printStackTrace();
            throw new StatusException("Could not register ", e);
        }
        log.println("    creating a new environment for object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        Object handler = null;
        try {
            handler = ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.sdb.InteractionHandler");
        }
        catch (Exception e) {
            log.println("Relation for XCompletedConnection wasn't created");
            e.printStackTrace(log);
        }
        tEnv.addObjRelation("UserAndPassword", new String[]{"", ""});
        tEnv.addObjRelation("XCompletedConnection.Handler", UnoRuntime.queryInterface(XInteractionHandler.class, handler));
        return tEnv;
    }
}

