/*
 * Decompiled with CFR 0.152.
 */
package mod._dbaccess;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.XDocumentDataSource;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.XNamingService;
import java.io.PrintWriter;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.utils;

public class ODatabaseContext
extends TestCase {
    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        Object oInterface = null;
        XMultiServiceFactory xMSF = null;
        try {
            xMSF = (XMultiServiceFactory)Param.getMSF();
            oInterface = xMSF.createInstance("com.sun.star.sdb.DatabaseContext");
        }
        catch (Exception e) {
            log.println("Service not available");
            throw new StatusException("Service not available", e);
        }
        if (oInterface == null) {
            log.println("Service wasn't created");
            throw new StatusException(Status.failed("Service wasn't created"));
        }
        oObj = (XInterface)oInterface;
        log.println("    creating a new environment for object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        try {
            xMSF = (XMultiServiceFactory)Param.getMSF();
            oInterface = xMSF.createInstance("com.sun.star.sdb.DataSource");
            XPropertySet xDSProps = UnoRuntime.queryInterface(XPropertySet.class, oInterface);
            xDSProps.setPropertyValue("URL", "sdbc:dbase:file:///.");
            XDocumentDataSource xDDS = UnoRuntime.queryInterface(XDocumentDataSource.class, oInterface);
            XStorable store = UnoRuntime.queryInterface(XStorable.class, (Object)xDDS.getDatabaseDocument());
            String aFile = utils.getOfficeTemp((XMultiServiceFactory)Param.getMSF()) + "DatabaseContext.odb";
            log.println("store to '" + aFile + "'");
            store.storeAsURL(aFile, new PropertyValue[0]);
            tEnv.addObjRelation("XNamingService.RegisterObject", oInterface);
            tEnv.addObjRelation("INSTANCE", oInterface);
            tEnv.addObjRelation("XContainer.Container", UnoRuntime.queryInterface(XNamingService.class, (Object)oObj));
        }
        catch (Exception e) {
            throw new StatusException("Can't create object relation", e);
        }
        catch (NullPointerException e) {
            throw new StatusException("Can't create object relation", e);
        }
        return tEnv;
    }
}

