/*
 * Decompiled with CFR 0.152.
 */
package mod._dbaccess;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.XDocumentDataSource;
import com.sun.star.sdb.XQueryDefinitionsSupplier;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XIsolatedConnection;
import com.sun.star.sdbc.XStatement;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.utils;

public class ConnectionLineAccessibility
extends TestCase {
    XWindow xWindow = null;
    Object oDBSource = null;
    String aFile = "";
    XConnection connection = null;
    XIsolatedConnection isolConnection = null;
    XComponent QueryComponent = null;
    String user = "";
    String password = "";

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XAccessibleContext oObj = null;
        Object oDBContext = null;
        Object oDBSource = null;
        Object newQuery = null;
        Object toolkit = null;
        XStorable store = null;
        try {
            oDBContext = ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.sdb.DatabaseContext");
            oDBSource = ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.sdb.DataSource");
            newQuery = ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.sdb.QueryDefinition");
            toolkit = ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't create instance"));
        }
        String mysqlURL = (String)Param.get("mysql.url");
        if (mysqlURL == null) {
            throw new StatusException(Status.failed("Couldn't get 'mysql.url' from ini-file"));
        }
        this.user = (String)Param.get("jdbc.user");
        this.password = (String)Param.get("jdbc.password");
        if (this.user == null || this.password == null) {
            throw new StatusException(Status.failed("Couldn't get 'jdbc.user' or 'jdbc.password' from ini-file"));
        }
        PropertyValue[] info = new PropertyValue[2];
        info[0] = new PropertyValue();
        info[0].Name = "user";
        info[0].Value = this.user;
        info[1] = new PropertyValue();
        info[1].Name = "password";
        info[1].Value = this.password;
        XPropertySet propSetDBSource = UnoRuntime.queryInterface(XPropertySet.class, oDBSource);
        try {
            propSetDBSource.setPropertyValue("URL", mysqlURL);
            propSetDBSource.setPropertyValue("Info", info);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't set property value"));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't set property value"));
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't set property value"));
        }
        catch (UnknownPropertyException e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't set property value"));
        }
        try {
            log.println("writing database file ...");
            XDocumentDataSource xDDS = UnoRuntime.queryInterface(XDocumentDataSource.class, oDBSource);
            store = UnoRuntime.queryInterface(XStorable.class, (Object)xDDS.getDatabaseDocument());
            this.aFile = utils.getOfficeTemp((XMultiServiceFactory)Param.getMSF()) + "ConnectionLine.odb";
            log.println("... filename will be " + this.aFile);
            store.storeAsURL(this.aFile, new PropertyValue[0]);
            log.println("... done");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't register object"));
        }
        this.isolConnection = UnoRuntime.queryInterface(XIsolatedConnection.class, oDBSource);
        XConnection connection = null;
        XStatement statement = null;
        String tbl_name1 = "tst_table1";
        String tbl_name2 = "tst_table2";
        String col_name1 = "id1";
        String col_name2 = "id2";
        try {
            connection = this.isolConnection.getIsolatedConnection(this.user, this.password);
            statement = connection.createStatement();
            statement.executeUpdate("drop table if exists tst_table1");
            statement.executeUpdate("drop table if exists tst_table2");
            statement.executeUpdate("create table tst_table1 (id1 int)");
            statement.executeUpdate("create table tst_table2 (id2 int)");
        }
        catch (SQLException e) {
            try {
                this.shortWait();
                connection = this.isolConnection.getIsolatedConnection(this.user, this.password);
                statement = connection.createStatement();
                statement.executeUpdate("drop table if exists tst_table1");
                statement.executeUpdate("drop table if exists tst_table2");
                statement.executeUpdate("create table tst_table1 (id1 int)");
                statement.executeUpdate("create table tst_table2 (id2 int)");
            }
            catch (SQLException e2) {
                e2.printStackTrace(log);
                throw new StatusException(Status.failed("SQLException"));
            }
        }
        XQueryDefinitionsSupplier querySuppl = UnoRuntime.queryInterface(XQueryDefinitionsSupplier.class, oDBSource);
        XNameAccess defContainer = querySuppl.getQueryDefinitions();
        XPropertySet queryProp = UnoRuntime.queryInterface(XPropertySet.class, newQuery);
        try {
            String query = "select * from tst_table1, tst_table2 where tst_table1.id1=tst_table2.id2";
            queryProp.setPropertyValue("Command", "select * from tst_table1, tst_table2 where tst_table1.id1=tst_table2.id2");
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't set property value"));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't set property value"));
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't set property value"));
        }
        catch (UnknownPropertyException e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't set property value"));
        }
        XNameContainer queryContainer = UnoRuntime.queryInterface(XNameContainer.class, (Object)defContainer);
        try {
            queryContainer.insertByName("Query1", newQuery);
            store.store();
            connection.close();
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't insert query"));
        }
        catch (ElementExistException e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't insert query"));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't insert query"));
        }
        catch (IOException e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't insert query"));
        }
        catch (SQLException e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't insert query"));
        }
        PropertyValue[] loadProps = new PropertyValue[3];
        loadProps[0] = new PropertyValue();
        loadProps[0].Name = "QueryDesignView";
        loadProps[0].Value = Boolean.TRUE;
        loadProps[1] = new PropertyValue();
        loadProps[1].Name = "CurrentQuery";
        loadProps[1].Value = "Query1";
        loadProps[2] = new PropertyValue();
        loadProps[2].Name = "DataSource";
        loadProps[2].Value = oDBSource;
        this.QueryComponent = DesktopTools.loadDoc((XMultiServiceFactory)Param.getMSF(), ".component:DB/QueryDesign", loadProps);
        utils.shortWait(1000);
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, toolkit);
        XTopWindow atw = tk.getActiveTopWindow();
        this.xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)atw);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(this.xWindow);
        AccessibilityTools.printAccessibleTree(log, xRoot, Param.getBool("DebugIsActive"));
        oObj = AccessibilityTools.getAccessibleObjectForRoleIgnoreShowing(xRoot, (short)0, "", "ConnectionLine");
        log.println("ImplementationName " + utils.getImplName(oObj));
        log.println("creating TestEnvironment");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        this.shortWait();
        final XWindow queryWin = this.xWindow;
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                Rectangle rect = queryWin.getPosSize();
                queryWin.setPosSize(rect.X, rect.Y, rect.Height - 5, rect.Width - 5, (short)15);
            }
        });
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        try {
            log.println("closing QueryComponent ...");
            DesktopTools.closeDoc(this.QueryComponent);
            log.println("... done");
            XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
            Object sfa = xMSF.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
            XSimpleFileAccess xSFA = UnoRuntime.queryInterface(XSimpleFileAccess.class, sfa);
            log.println("deleting database file");
            xSFA.kill(this.aFile);
            log.println("Could delete file " + this.aFile + ": " + !xSFA.exists(this.aFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void shortWait() {
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }
}

