/*
 * Decompiled with CFR 0.152.
 */
package mod._connector.uno;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.utils;

public class Connector
extends TestCase {
    protected static final int basePort = 10000;
    private int curPort;
    private static String sOfficeHost = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        String cncstr = (String)tParam.get("CNCSTR");
        int idx = cncstr.indexOf("host=") + 5;
        sOfficeHost = cncstr.substring(idx, cncstr.indexOf(",", idx));
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        try {
            XInterface connector;
            oObj = connector = (XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.connection.Connector");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create object environment", e);
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        this.curPort = utils.getNextFreePort(10000);
        log.println("Choose Port nr: " + this.curPort);
        tEnv.addObjRelation("XConnector.connectStr", "socket,host=" + sOfficeHost + ",port=" + this.curPort);
        tEnv.addObjRelation("Connector.Port", new Integer(this.curPort));
        return tEnv;
    }

    @Override
    public synchronized void disposeTestEnvironment(TestEnvironment tEnv, TestParameters tParam) {
        this.curPort = (Integer)tEnv.getObjRelation("Connector.Port");
    }
}

