/*
 * Decompiled with CFR 0.152.
 */
package mod._bridgefac.uno;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.utils;

public class BridgeFactory
extends TestCase {
    protected static final int basePort = 50003;
    private int curPort;
    private static String sOfficeHost = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        String cncstr = (String)tParam.get("CNCSTR");
        int idx = cncstr.indexOf("host=") + 5;
        sOfficeHost = cncstr.substring(idx, cncstr.indexOf(",", idx));
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        try {
            oObj = (XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.bridge.BridgeFactory");
        }
        catch (Exception e) {
            throw new StatusException("Can't create object environment", e);
        }
        if (oObj == null) {
            throw new StatusException("Can't create service", new NullPointerException());
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        this.curPort = utils.getNextFreePort(50003);
        log.println("Choose Port nr: " + this.curPort);
        tEnv.addObjRelation("CNNCTSTR", "socket,host=" + sOfficeHost + ",port=" + this.curPort);
        tEnv.addObjRelation("Connector.Port", new Integer(this.curPort));
        return tEnv;
    }

    @Override
    public synchronized void disposeTestEnvironment(TestEnvironment tEnv, TestParameters tParam) {
        this.curPort = (Integer)tEnv.getObjRelation("Connector.Port");
    }
}

