/*
 * Decompiled with CFR 0.152.
 */
package mod._basctl;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatchHelper;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.WriterTools;
import util.utils;

public class AccessibleShape
extends TestCase {
    XTextDocument xTextDoc = null;
    XInterface oObj = null;
    XWindow basicIDE = null;

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("Cleaning up");
        DesktopTools.closeDoc(this.xTextDoc);
        try {
            XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
            Object o = xMSF.createInstance("com.sun.star.frame.Desktop");
            XDesktop xDesk = UnoRuntime.queryInterface(XDesktop.class, o);
            DesktopTools.closeDoc(xDesk.getCurrentFrame());
        }
        catch (Exception e) {
            log.println("Couldn't close IDE");
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        log.println("creating a test environment");
        String aURL = utils.getFullTestURL("basDialog.odt");
        this.xTextDoc = WriterTools.loadTextDoc(xMSF, aURL);
        XModel xModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xTextDoc);
        XFrame xFrame = xModel.getCurrentController().getFrame();
        XDispatchProvider xDPP = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xFrame);
        log.println("opening the basic dialog editor");
        try {
            Object o = xMSF.createInstance("com.sun.star.frame.DispatchHelper");
            XDispatchHelper xDPH = UnoRuntime.queryInterface(XDispatchHelper.class, o);
            PropertyValue[] aArgs = new PropertyValue[4];
            aArgs[0] = new PropertyValue();
            aArgs[0].Name = "Document";
            aArgs[0].Value = aURL;
            aArgs[1] = new PropertyValue();
            aArgs[1].Name = "LibName";
            aArgs[1].Value = "basctl";
            aArgs[2] = new PropertyValue();
            aArgs[2].Name = "Name";
            aArgs[2].Value = "Dialog1";
            aArgs[3] = new PropertyValue();
            aArgs[3].Name = "Type";
            aArgs[3].Value = "Dialog";
            xDPH.executeDispatch(xDPP, ".uno:BasicIDEAppear", "", 0, aArgs);
        }
        catch (Exception e) {
            throw new StatusException("Couldn't open Basic Dialog", e);
        }
        utils.shortWait(3000);
        try {
            this.oObj = (XInterface)((XMultiServiceFactory)tParam.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (com.sun.star.uno.Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)this.oObj);
        AccessibilityTools at = new AccessibilityTools();
        this.basicIDE = UnoRuntime.queryInterface(XWindow.class, (Object)tk.getActiveTopWindow());
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(this.basicIDE);
        AccessibilityTools.printAccessibleTree(log, xRoot, tParam.getBool("DebugIsActive"));
        this.oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)52);
        TestEnvironment tEnv = new TestEnvironment(this.oObj);
        log.println("Implementation Name: " + utils.getImplName(this.oObj));
        tEnv.addObjRelation("Destroy", Boolean.TRUE);
        final XExtendedToolkit subtk = tk;
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                XWindow xWin = UnoRuntime.queryInterface(XWindow.class, (Object)subtk.getActiveTopWindow());
                Rectangle oldPosSize = xWin.getPosSize();
                Rectangle newPosSize = new Rectangle();
                newPosSize.Width = oldPosSize.Width / 2;
                newPosSize.Height = oldPosSize.Height / 2;
                newPosSize.X = oldPosSize.X + 20;
                newPosSize.Y = oldPosSize.Y + 20;
                xWin.setPosSize(newPosSize.X, newPosSize.Y, newPosSize.Width, newPosSize.Height, (short)15);
                utils.shortWait(1000);
                xWin.setPosSize(oldPosSize.X, oldPosSize.Y, oldPosSize.Width, oldPosSize.Height, (short)15);
            }
        });
        return tEnv;
    }
}

