/*
 * Decompiled with CFR 0.152.
 */
package mod._acceptor.uno;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.utils;

public class Acceptor
extends TestCase {
    private XInterface acceptor = null;
    protected static final int basePort = 10000;
    private int curPort;
    private static String sOfficeHost = null;

    @Override
    public void initialize(TestParameters tParam, PrintWriter log) {
        String cncstr = (String)tParam.get("CNCSTR");
        int idx = cncstr.indexOf("host=") + 5;
        sOfficeHost = cncstr.substring(idx, cncstr.indexOf(",", idx));
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        XInterface acceptor = null;
        try {
            acceptor = (XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.connection.Acceptor");
        }
        catch (Exception e) {
            throw new StatusException("Can't create object environment", e);
        }
        this.curPort = utils.getNextFreePort(10000);
        log.println("Choose Port nr: " + this.curPort);
        oObj = acceptor;
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("XAcceptor.connectStr", "socket,host=" + sOfficeHost + ",port=" + this.curPort);
        tEnv.addObjRelation("Acceptor.Port", new Integer(this.curPort));
        return tEnv;
    }

    @Override
    public synchronized void disposeTestEnvironment(TestEnvironment tEnv, TestParameters tParam) {
        this.curPort = (Integer)tEnv.getObjRelation("Acceptor.Port");
    }
}

