/*
 * Decompiled with CFR 0.152.
 */
package lib;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.Hashtable;

public class TestParameters
extends Hashtable {
    public String ConnectionString = "socket,host=localhost,port=8100";
    public Object AppProvider = null;
    public Object ProcessHandler = null;
    public String AppExecutionCommand = "";
    public boolean AutoRestart = false;
    public int ShortWait = 500;
    public String OfficeProvider = "helper.OfficeProvider";
    public String TestBase = "java_fat";
    public Object ServiceFactory;
    public String DescriptionPath;
    public String TestDocumentPath = "unkown";
    public boolean LoggingIsActive = true;
    public boolean DebugIsActive = false;
    public Object TestJob;
    public String LogWriter = "stats.SimpleLogWriter";
    public String OutProducer = "stats.SimpleOutProducer";
    public Integer TimeOut = new Integer(3000000);
    public Integer ThreadTimeOut = new Integer(3000000);
    public Integer OfficeCloseTimeOut = new Integer(15000);

    @Override
    public Object get(Object key) {
        Object val = super.get(key);
        if (val == null && this.DebugIsActive) {
            System.out.print("Have been asked for key \"" + key.toString());
            System.out.println("\" which is not part of params.");
        }
        return val;
    }

    public boolean getBool(Object key) {
        Object val = super.get(key);
        if (val != null) {
            if (val instanceof String) {
                String sVal = (String)val;
                if (sVal.equalsIgnoreCase("true") || sVal.equalsIgnoreCase("yes")) {
                    return true;
                }
                if (sVal.equalsIgnoreCase("false") || sVal.equalsIgnoreCase("no")) {
                    return false;
                }
            }
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
        }
        return false;
    }

    public int getInt(Object key) {
        Object val = super.get(key);
        if (val != null) {
            if (val instanceof Integer) {
                return (Integer)val;
            }
            try {
                Integer nr;
                if (val instanceof String && (nr = new Integer((String)val)) > 0) {
                    return nr;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public Object put(Object key, Object val) {
        return super.put(key, val);
    }

    public TestParameters() {
        String user = System.getProperty("user.name");
        if (user != null) {
            String PipeConnectionString = "pipe,name=" + user;
            this.put("PipeConnectionString", PipeConnectionString);
            this.put("UsePipeConnection", Boolean.TRUE);
        }
        this.put("ConnectionString", this.ConnectionString);
        this.put("TestBase", this.TestBase);
        this.put("TestDocumentPath", this.TestDocumentPath);
        this.put("LoggingIsActive", this.LoggingIsActive ? Boolean.TRUE : Boolean.FALSE);
        this.put("DebugIsActive", this.DebugIsActive ? Boolean.TRUE : Boolean.FALSE);
        this.put("OutProducer", this.OutProducer);
        this.put("ShortWait", new Integer(this.ShortWait));
        this.put("OfficeProvider", this.OfficeProvider);
        this.put("LogWriter", this.LogWriter);
        this.put("AppExecutionCommand", this.AppExecutionCommand);
        this.put("TimeOut", this.TimeOut);
        this.put("ThreadTimeOut", this.ThreadTimeOut);
        this.put("AutoRestart", this.AutoRestart ? Boolean.TRUE : Boolean.FALSE);
        this.put("OfficeCloseTimeOut", this.OfficeCloseTimeOut);
        this.put("OperatingSystem", this.getSOCompatibleOSName());
        this.put("CNCSTR", this.ConnectionString);
        this.put("DOCPTH", this.TestDocumentPath);
        System.setProperty("DOCPTH", this.TestDocumentPath);
    }

    public Object getMSF() {
        Object ret = null;
        ret = this.get("ServiceFactory");
        return ret;
    }

    public XComponentContext getComponentContext() {
        Object context = this.get("ComponentContext");
        if (context == null) {
            XPropertySet factoryProps = UnoRuntime.queryInterface(XPropertySet.class, this.getMSF());
            try {
                context = UnoRuntime.queryInterface(XComponentContext.class, factoryProps.getPropertyValue("DefaultContext"));
                this.put("ComponentContext", context);
            }
            catch (UnknownPropertyException e) {
            }
            catch (WrappedTargetException wrappedTargetException) {
                // empty catch block
            }
        }
        return (XComponentContext)context;
    }

    String getSOCompatibleOSName() {
        String osname = System.getProperty("os.name").toLowerCase();
        String osarch = System.getProperty("os.arch");
        String operatingSystem = "";
        if (osname.indexOf("windows") > -1) {
            operatingSystem = "wntmsci";
        } else if (osname.indexOf("linux") > -1) {
            operatingSystem = "unxlngi";
        } else if (osname.indexOf("sunos") > -1) {
            operatingSystem = osarch.equals("x86") ? "unxsoli" : "unxsols";
        } else if (osname.indexOf("mac") > -1) {
            operatingSystem = "unxmacxi";
        } else {
            System.out.println("ERROR: not supported platform: " + osname);
            System.exit(1);
        }
        return operatingSystem;
    }
}

