/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.io.PrintWriter;
import lib.TestEnvironment;
import lib.TestParameters;

public abstract class TestCase {
    public PrintWriter log;

    public void setLogWriter(PrintWriter log) {
        this.log = log;
    }

    public void initializeTestCase(TestParameters tParam) {
        this.initialize(tParam, this.log);
    }

    protected void initialize(TestParameters tParam, PrintWriter log) {
    }

    public void cleanupTestCase(TestParameters tParam) {
        this.cleanup(tParam, this.log);
    }

    protected void cleanup(TestParameters tParam, PrintWriter log) {
    }

    public synchronized TestEnvironment getTestEnvironment(TestParameters tParam) {
        TestEnvironment tEnv = null;
        try {
            tEnv = this.createTestEnvironment(tParam, this.log);
            System.out.println("Environment created");
            if (tEnv != null) {
                tEnv.setTestCase(this);
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            System.out.println("Exception while getting Environment " + message);
            e.printStackTrace();
        }
        return tEnv;
    }

    public synchronized void disposeTestEnvironment(TestEnvironment tEnv, TestParameters tParam) {
        this.cleanup(tParam, this.log);
    }

    protected abstract TestEnvironment createTestEnvironment(TestParameters var1, PrintWriter var2);

    protected void cleanupTestEnvironment(TestParameters Param, TestEnvironment tEnv, PrintWriter log) {
    }

    public String getObjectName() {
        String clName = this.getClass().getName();
        return clName.substring(clName.lastIndexOf(46) + 1);
    }
}

