/*
 * Decompiled with CFR 0.152.
 */
package lib;

import lib.ExceptionStatus;
import lib.SimpleStatus;

public class Status
extends SimpleStatus {
    public Status(int runState, boolean state) {
        super(runState, state);
    }

    public Status(String message, boolean state) {
        super(message, state);
    }

    public static Status passed(boolean state) {
        return new Status(0, state);
    }

    public static Status exception(Throwable t) {
        return new ExceptionStatus(t);
    }

    public static Status skipped(boolean state) {
        return new Status(1, state);
    }

    public static Status excluded() {
        return new Status(2, false);
    }

    public static Status failed(String reason) {
        return new Status(reason, false);
    }

    public String toString() {
        String str = this.getRunStateString() + "." + this.getStateString();
        return str;
    }

    public boolean isPassed() {
        return this.getRunState() == 0;
    }

    public boolean isSkipped() {
        return this.getRunState() == 1;
    }

    public boolean isExcluded() {
        return this.getRunState() == 2;
    }

    public boolean isException() {
        return this.getRunState() == 3;
    }

    public boolean isFailed() {
        return !this.getState();
    }

    public boolean isOK() {
        return this.getState();
    }

    public String getDescription() {
        return this.getRunStateString();
    }
}

