/*
 * Decompiled with CFR 0.152.
 */
package lib;

import com.sun.star.beans.Property;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.Type;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class Parameters
implements XPropertySet {
    protected final Map parameters;
    final Parameters defaults;
    Property[] props;

    public Parameters(Map params) {
        this(params, null);
    }

    public Parameters(Map params, Parameters defaultParams) {
        this.parameters = params;
        this.defaults = defaultParams;
        Parameters.checkParameters(this.parameters);
        HashSet paramSet = new HashSet(this.parameters.keySet());
        if (this.defaults != null) {
            Set defSet = this.defaults.toMap().keySet();
            paramSet.addAll(defSet);
        }
        this.props = new Property[paramSet.size()];
        int num = 0;
        for (String name : paramSet) {
            this.props[num] = new Property(name, num, new Type(String.class), 0);
            ++num;
        }
    }

    public String get(String paramName) {
        Object res = this.parameters.get(paramName);
        if (res != null && res instanceof String) {
            return (String)res;
        }
        if (this.defaults != null) {
            return this.defaults.get(paramName);
        }
        return null;
    }

    @Override
    public Object getPropertyValue(String name) {
        Object erg = this.parameters.get(name);
        if (erg == null && this.defaults != null) {
            return this.defaults.getPropertyValue(name);
        }
        return erg;
    }

    @Override
    public void setPropertyValue(String name, Object value) {
        this.parameters.put(name, value);
        int size = this.props.length;
        Property[] addProps = new Property[size + 1];
        for (int i = 0; i < size; ++i) {
            addProps[i] = this.props[i];
        }
        addProps[size] = new Property(name, size, new Type(value.getClass()), 0);
        this.props = addProps;
    }

    @Override
    public void addVetoableChangeListener(String name, XVetoableChangeListener l) {
    }

    @Override
    public void removeVetoableChangeListener(String name, XVetoableChangeListener l) {
    }

    @Override
    public void addPropertyChangeListener(String name, XPropertyChangeListener l) {
    }

    @Override
    public void removePropertyChangeListener(String name, XPropertyChangeListener l) {
    }

    @Override
    public XPropertySetInfo getPropertySetInfo() {
        return new XPropertySetInfo(){

            @Override
            public Property[] getProperties() {
                return Parameters.this.props;
            }

            @Override
            public boolean hasPropertyByName(String name) {
                for (int i = 0; i < Parameters.this.props.length; ++i) {
                    Property prop = Parameters.this.props[i];
                    if (!prop.Name.equals(name)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Property getPropertyByName(String name) throws UnknownPropertyException {
                for (int i = 0; i < Parameters.this.props.length; ++i) {
                    Property prop = Parameters.this.props[i];
                    if (!prop.Name.equals(name)) continue;
                    return prop;
                }
                throw new UnknownPropertyException(name);
            }
        };
    }

    public Map toMap() {
        return new Hashtable(this.parameters){

            @Override
            public Object get(Object obj) {
                if (obj instanceof String) {
                    return Parameters.this.get((String)obj);
                }
                return null;
            }
        };
    }

    private static void checkParameters(Map params) {
        for (Object key : params.keySet()) {
            if (key instanceof String) continue;
            throw new IllegalArgumentException("Wrong key " + key + ", it should be of String type");
        }
    }

    public static String getString(XPropertySet props, String name) {
        try {
            return (String)props.getPropertyValue(name);
        }
        catch (UnknownPropertyException e) {
            return null;
        }
        catch (WrappedTargetException e) {
            return null;
        }
    }

    public static Object get(XPropertySet props, String name) {
        try {
            return props.getPropertyValue(name);
        }
        catch (UnknownPropertyException e) {
            return null;
        }
        catch (WrappedTargetException e) {
            return null;
        }
    }

    public static Map toMap(XPropertySet props) {
        Hashtable<String, Object> result = new Hashtable<String, Object>(10);
        XPropertySetInfo setInfo = props.getPropertySetInfo();
        Property[] properties = setInfo.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            Object value;
            String name = properties[i].Name;
            try {
                value = props.getPropertyValue(name);
            }
            catch (WrappedTargetException e) {
                continue;
            }
            catch (UnknownPropertyException e) {
                continue;
            }
            result.put(name, value);
        }
        return result;
    }
}

