/*
 * Decompiled with CFR 0.152.
 */
package lib;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.lang.reflect.Method;
import lib.MultiMethodTest;
import lib.Status;
import util.ValueChanger;
import util.ValueComparer;
import util.utils;

public class MultiPropertyTest
extends MultiMethodTest {
    public XPropertySet oObj;
    protected boolean optionalService = false;

    @Override
    protected void before() {
        XServiceInfo xInfo = UnoRuntime.queryInterface(XServiceInfo.class, (Object)this.oObj);
        this.optionalService = this.entry.isOptional;
        String theService = this.getTestedClassName();
        if (xInfo != null && !xInfo.supportsService(theService)) {
            this.log.println("Service " + theService + " not available");
            if (this.optionalService) {
                this.log.println("This is OK since it is optional");
            } else {
                Status.failed(theService + " is not supported");
            }
        }
    }

    @Override
    protected void invokeTestMethod(Method meth, String methName) {
        if (meth != null) {
            super.invokeTestMethod(meth, methName);
        } else {
            this.testProperty(methName);
        }
    }

    protected void testProperty(String propName, PropertyTester propTester) {
        propTester.testProperty(propName);
    }

    protected void testProperty(String propName) {
        this.testProperty(propName, new PropertyTester());
    }

    protected void testProperty(String propName, Object val1, Object val2) {
        this.testProperty(propName, new PropertyValueSwitcher(val1, val2));
    }

    private boolean callCompare(Object obj1, Object obj2) {
        return this.compare(obj1, obj2);
    }

    protected boolean compare(Object obj1, Object obj2) {
        return ValueComparer.equalValue(obj1, obj2);
    }

    private String callToString(Object obj) {
        return this.toString(obj);
    }

    protected String toString(Object obj) {
        return obj == null ? "null" : obj.toString();
    }

    public class PropertyValueSwitcher
    extends PropertyTester {
        Object val1;
        Object val2;

        public PropertyValueSwitcher(Object val1, Object val2) {
            this.val1 = null;
            this.val2 = null;
            this.val1 = val1;
            this.val2 = val2;
        }

        @Override
        protected Object getNewValue(String propName, Object old) {
            if (ValueComparer.equalValue(this.val1, old)) {
                return this.val2;
            }
            return this.val1;
        }
    }

    public class PropertyTester {
        protected void testProperty(String propName) {
            XPropertySetInfo info = MultiPropertyTest.this.oObj.getPropertySetInfo();
            if (info != null && !info.hasPropertyByName(propName)) {
                if (MultiPropertyTest.this.isOptional(propName) || MultiPropertyTest.this.optionalService) {
                    MultiPropertyTest.this.log.println("Property '" + propName + "' is optional and not supported");
                    MultiPropertyTest.this.tRes.tested(propName, true);
                    return;
                }
                MultiPropertyTest.this.log.println("Tested XPropertySet does not contain'" + propName + "' property");
                MultiPropertyTest.this.tRes.tested(propName, false);
                return;
            }
            try {
                Object newValue;
                Object oldValue = MultiPropertyTest.this.oObj.getPropertyValue(propName);
                try {
                    newValue = this.getNewValue(propName, oldValue);
                }
                catch (java.lang.IllegalArgumentException e) {
                    Status.failed("Cannot create new value for '" + propName + " : " + e.getMessage());
                    return;
                }
                Exception exception = null;
                try {
                    MultiPropertyTest.this.log.println("try to set:");
                    MultiPropertyTest.this.log.println("old = " + this.toString(oldValue));
                    MultiPropertyTest.this.log.println("new = " + this.toString(newValue));
                    MultiPropertyTest.this.oObj.setPropertyValue(propName, newValue);
                }
                catch (IllegalArgumentException e) {
                    exception = e;
                }
                catch (PropertyVetoException e) {
                    exception = e;
                }
                catch (WrappedTargetException e) {
                    exception = e;
                }
                catch (UnknownPropertyException e) {
                    exception = e;
                }
                catch (RuntimeException e) {
                    exception = e;
                }
                Object resValue = MultiPropertyTest.this.oObj.getPropertyValue(propName);
                this.checkResult(propName, oldValue, newValue, resValue, exception);
            }
            catch (Exception e) {
                MultiPropertyTest.this.log.println("Exception occured while testing property '" + propName + "'");
                e.printStackTrace(MultiPropertyTest.this.log);
                MultiPropertyTest.this.tRes.tested(propName, false);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void checkResult(String propName, Object oldValue, Object newValue, Object resValue, Exception exception) throws Exception {
            boolean maybeVoid;
            XPropertySetInfo info = MultiPropertyTest.this.oObj.getPropertySetInfo();
            if (info == null) {
                MultiPropertyTest.this.log.println("Can't get XPropertySetInfo for property " + propName);
                MultiPropertyTest.this.tRes.tested(propName, false);
                return;
            }
            Property prop = info.getPropertyByName(propName);
            short attr = prop.Attributes;
            boolean readOnly = (prop.Attributes & 0x10) != 0;
            boolean bl = maybeVoid = (prop.Attributes & 1) != 0;
            if (maybeVoid) {
                MultiPropertyTest.this.log.println("Property " + propName + " is void");
            }
            if (readOnly) {
                MultiPropertyTest.this.log.println("Property " + propName + " is readOnly");
            }
            if (utils.isVoid(oldValue) && !maybeVoid) {
                MultiPropertyTest.this.log.println(propName + " is void, but it's not MAYBEVOID");
                MultiPropertyTest.this.tRes.tested(propName, false);
                return;
            }
            if (oldValue == null) {
                MultiPropertyTest.this.log.println(propName + " has null value, and therefore can't be changed");
                MultiPropertyTest.this.tRes.tested(propName, true);
                return;
            }
            if (readOnly) {
                if (exception != null) {
                    if (exception instanceof PropertyVetoException) {
                        MultiPropertyTest.this.log.println("Property is ReadOnly and wasn't changed");
                        MultiPropertyTest.this.log.println("Property '" + propName + "' OK");
                        MultiPropertyTest.this.tRes.tested(propName, true);
                        return;
                    } else if (exception instanceof IllegalArgumentException) {
                        MultiPropertyTest.this.log.println("Property is ReadOnly and wasn't changed");
                        MultiPropertyTest.this.log.println("Property '" + propName + "' OK");
                        MultiPropertyTest.this.tRes.tested(propName, true);
                        return;
                    } else if (exception instanceof UnknownPropertyException) {
                        MultiPropertyTest.this.log.println("Property is ReadOnly and wasn't changed");
                        MultiPropertyTest.this.log.println("Property '" + propName + "' OK");
                        MultiPropertyTest.this.tRes.tested(propName, true);
                        return;
                    } else {
                        if (!(exception instanceof RuntimeException)) throw exception;
                        MultiPropertyTest.this.log.println("Property is ReadOnly and wasn't changed");
                        MultiPropertyTest.this.log.println("Property '" + propName + "' OK");
                        MultiPropertyTest.this.tRes.tested(propName, true);
                    }
                    return;
                }
                if (!this.compare(resValue, oldValue)) {
                    MultiPropertyTest.this.log.println("Read only property '" + propName + "' has changed");
                    try {
                        if (!utils.isVoid(oldValue) && oldValue instanceof Any) {
                            oldValue = AnyConverter.toObject((Type)new Type(((Any)oldValue).getClass()), (Object)oldValue);
                        }
                        MultiPropertyTest.this.log.println("result = " + this.toString(resValue));
                    }
                    catch (IllegalArgumentException iae) {
                        MultiPropertyTest.this.log.println("NOTIFY: this property needs further investigations.");
                        MultiPropertyTest.this.log.println("\t The type seems to be an Any with value of NULL.");
                        MultiPropertyTest.this.log.println("\t Maybe the property should get it's own test method.");
                    }
                    MultiPropertyTest.this.tRes.tested(propName, false);
                    return;
                }
                MultiPropertyTest.this.log.println("Read only property '" + propName + "' hasn't changed");
                MultiPropertyTest.this.log.println("Property '" + propName + "' OK");
                MultiPropertyTest.this.tRes.tested(propName, true);
                return;
            }
            if (exception != null) throw exception;
            if (!this.compare(resValue, newValue) || this.compare(resValue, oldValue)) {
                MultiPropertyTest.this.log.println("Value for '" + propName + "' hasn't changed as expected");
                try {
                    if (!utils.isVoid(oldValue) && oldValue instanceof Any) {
                        oldValue = AnyConverter.toObject((Type)new Type(((Any)oldValue).getClass()), (Object)oldValue);
                    }
                    MultiPropertyTest.this.log.println("result = " + this.toString(resValue));
                }
                catch (IllegalArgumentException iae) {
                    MultiPropertyTest.this.log.println("NOTIFY: this property needs further investigations.");
                    MultiPropertyTest.this.log.println("\t The type seems to be an Any with value of NULL.");
                    MultiPropertyTest.this.log.println("\t Maybe the property should get it's own test method.");
                }
                if (resValue != null) {
                    if (!this.compare(resValue, oldValue) || !resValue.equals(oldValue)) {
                        MultiPropertyTest.this.log.println("But it has changed.");
                        MultiPropertyTest.this.tRes.tested(propName, true);
                        return;
                    } else {
                        MultiPropertyTest.this.tRes.tested(propName, false);
                    }
                    return;
                } else {
                    MultiPropertyTest.this.tRes.tested(propName, false);
                }
                return;
            }
            MultiPropertyTest.this.log.println("Property '" + propName + "' OK");
            try {
                if (!utils.isVoid(oldValue) && oldValue instanceof Any) {
                    oldValue = AnyConverter.toObject((Type)new Type(((Any)oldValue).getClass()), (Object)oldValue);
                }
                MultiPropertyTest.this.log.println("result = " + this.toString(resValue));
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
            MultiPropertyTest.this.tRes.tested(propName, true);
        }

        protected Object getNewValue(String propName, Object oldValue) throws java.lang.IllegalArgumentException {
            return ValueChanger.changePValue(oldValue);
        }

        protected boolean compare(Object obj1, Object obj2) {
            return MultiPropertyTest.this.callCompare(obj1, obj2);
        }

        protected String toString(Object obj) {
            return MultiPropertyTest.this.callToString(obj);
        }
    }
}

