/*
 * Decompiled with CFR 0.152.
 */
package lib;

import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import lib.TestResult;
import share.DescEntry;
import stats.Summarizer;

public class MultiMethodTest {
    protected TestEnvironment tEnv;
    protected TestParameters tParam;
    protected DescEntry entry;
    protected PrintWriter log;
    protected TestResult tRes;
    private Vector methCalled = new Vector(10);

    public void disposeEnvironment(TestEnvironment tEnv) {
        this.disposeEnvironment();
    }

    public void disposeEnvironment() {
        this.tEnv.dispose();
        TestCase tCase = this.tEnv.getTestCase();
        tCase.disposeTestEnvironment(this.tEnv, this.tParam);
    }

    public TestResult run(DescEntry entry, TestEnvironment tEnv, TestParameters tParam) {
        this.log = (PrintWriter)((Object)entry.Logger);
        this.tEnv = tEnv;
        this.tParam = tParam;
        this.entry = entry;
        this.tRes = new TestResult();
        if (!entry.entryName.equals("ifc.qadevooo._SelfTest")) {
            Class<?> testedClass;
            String ifcName = this.getInterfaceName();
            System.out.println("checking : " + ifcName);
            String testedClassName = this.getTestedClassName();
            if (entry.EntryType.equals("service")) {
                testedClassName = "com.sun.star.beans.XPropertySet";
            }
            try {
                testedClass = Class.forName(testedClassName);
            }
            catch (ClassNotFoundException cnfE) {
                cnfE.printStackTrace(this.log);
                this.log.println("could not find a class : " + this.getTestedClassName());
                return null;
            }
            XInterface tCase = tEnv.getTestObject();
            Object oObj = UnoRuntime.queryInterface(testedClass, (Object)tEnv.getTestObject());
            if (oObj == null) {
                if (entry.isOptional) {
                    Summarizer.summarizeDown(entry, "Not supported but optional.OK");
                } else {
                    Summarizer.summarizeDown(entry, "queryInterface returned null.FAILED");
                    entry.ErrorMsg = "queryInterface returned null";
                    entry.hasErrorMsg = true;
                }
                return null;
            }
            this.setField("oObj", oObj);
        }
        try {
            this.before();
        }
        catch (Exception e) {
            this.setSubStates(e.toString());
            return this.tRes;
        }
        for (int i = 0; i < entry.SubEntryCount; ++i) {
            DescEntry aSubEntry = entry.SubEntries[i];
            try {
                this.executeMethod(aSubEntry.entryName);
                continue;
            }
            catch (Exception e) {
                this.log.println("Exception while checking: " + aSubEntry.entryName + " : " + e.getMessage());
            }
        }
        try {
            this.after();
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.tRes;
    }

    protected void before() throws Exception {
    }

    protected void after() {
    }

    protected String getTestedClassName() {
        String clsName = this.getClass().getName();
        int firstDot = clsName.indexOf(".");
        int lastDot = clsName.lastIndexOf(".");
        String append = "com.sun.star.";
        if (this.entry.longName.indexOf("::drafts::com::") > -1) {
            append = "drafts.com.sun.star.";
        }
        return append + clsName.substring(firstDot + 1, lastDot + 1) + clsName.substring(lastDot + 2);
    }

    protected void setStatus(String methName, Status methStatus) {
        this.tRes.tested(methName, methStatus);
    }

    protected void setSubStates(String msg) {
        for (int k = 0; k < this.entry.SubEntryCount; ++k) {
            this.entry.SubEntries[k].hasErrorMsg = true;
            this.entry.SubEntries[k].ErrorMsg = msg;
            if (!this.entry.SubEntries[k].State.equals("UNKNOWN")) continue;
            this.entry.SubEntries[k].State = msg;
        }
    }

    protected boolean isOptional(String method) {
        for (int k = 0; k < this.entry.SubEntryCount; ++k) {
            if (!this.entry.SubEntries[k].entryName.equals(method)) continue;
            return this.entry.SubEntries[k].isOptional;
        }
        return false;
    }

    protected boolean isCalled(String method) {
        return this.methCalled.contains(method);
    }

    protected void requiredMethod(String method) {
        this.log.println("starting required method: " + method);
        this.executeMethod(method);
        Status mtStatus = this.tRes.getStatusFor(method);
        if (mtStatus != null && (!mtStatus.isPassed() || mtStatus.isFailed())) {
            this.log.println("! Required method " + method + " failed");
            throw new StatusException(mtStatus);
        }
    }

    protected void executeMethod(String method) {
        if (!this.isCalled(method)) {
            this.log.println("Execute: " + method);
            this.callMethod(method);
            this.log.println(method + ": " + this.tRes.getStatusFor(method));
        }
    }

    protected void callMethod(String method) {
        this.methCalled.add(method);
        this.invokeTestMethod(this.getMethodFor(method), method);
    }

    protected void invokeTestMethod(Method meth, String methName) {
        if (meth == null) {
            this.setStatus(methName, Status.skipped(false));
        } else {
            Status stat;
            try {
                meth.invoke((Object)this, new Object[0]);
                return;
            }
            catch (InvocationTargetException itE) {
                Throwable t = itE.getTargetException();
                if (t instanceof StatusException) {
                    stat = ((StatusException)t).getStatus();
                } else {
                    t.printStackTrace(this.log);
                    stat = Status.exception(t);
                }
            }
            catch (IllegalAccessException iaE) {
                iaE.printStackTrace(this.log);
                stat = Status.exception(iaE);
            }
            catch (IllegalArgumentException iaE) {
                iaE.printStackTrace(this.log);
                stat = Status.exception(iaE);
            }
            catch (ClassCastException ccE) {
                ccE.printStackTrace(this.log);
                stat = Status.exception(ccE);
            }
            this.setStatus(methName, stat);
        }
    }

    protected Method getMethodFor(String method) {
        String mName = "_" + method;
        if (mName.endsWith("()")) {
            mName = mName.substring(0, mName.length() - 2);
        }
        Class[] paramTypes = new Class[]{};
        try {
            return this.getClass().getDeclaredMethod(mName, paramTypes);
        }
        catch (NoSuchMethodException nsmE) {
            return null;
        }
    }

    public String getInterfaceName() {
        String clName = this.getClass().getName();
        return clName.substring(clName.lastIndexOf(46) + 1);
    }

    protected Status setField(String fieldName, Object value) {
        Field objField;
        try {
            objField = this.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException nsfE) {
            return Status.exception(nsfE);
        }
        try {
            objField.set(this, value);
            return Status.passed(true);
        }
        catch (IllegalArgumentException iaE) {
            return Status.exception(iaE);
        }
        catch (IllegalAccessException iaE) {
            return Status.exception(iaE);
        }
    }
}

