/*
 * Decompiled with CFR 0.152.
 */
package ifc.xml.sax;

import com.sun.star.xml.sax.SAXException;
import com.sun.star.xml.sax.XDocumentHandler;
import com.sun.star.xml.sax.XLocator;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.XMLTools;

public class _XDocumentHandler
extends MultiMethodTest {
    public XDocumentHandler oObj = null;
    private String[][] xmlData = null;
    private DocumentLocator locator = null;
    private ImportChecker checker = null;
    private boolean locatorResult = true;
    private SAXException locatorException = null;
    private boolean ToBeSkipped = false;

    @Override
    public void before() {
        this.locator = new DocumentLocator(this.log);
        if (this.tEnv.getTestCase().getObjectName().equals("XMLSettingsImporter")) {
            this.log.println("Settings can't be imported in the current Implementation");
            this.ToBeSkipped = true;
        }
        this.xmlData = (String[][])this.tEnv.getObjRelation("XDocumentHandler.XMLData");
        this.checker = (ImportChecker)this.tEnv.getObjRelation("XDocumentHandler.ImportChecker");
        TargetDocumentSetter targetDocSet = (TargetDocumentSetter)this.tEnv.getObjRelation("XDocumentHandler.TargetDocumentSetter");
        if (this.xmlData == null || this.checker == null) {
            throw new StatusException(Status.failed("Relation wasn't found"));
        }
        if (targetDocSet == null) {
            this.log.println("object realtion 'XDocumentHandler.TargetDocumentSetter' not used.");
            this.log.println("be shure that the test have a target to write throu");
        }
    }

    public void _startDocument() {
        if (this.ToBeSkipped) {
            this.tRes.tested("startDocument()", Status.skipped(true));
            return;
        }
        try {
            this.oObj.setDocumentLocator(this.locator);
        }
        catch (SAXException e) {
            this.locatorException = e;
            this.locatorResult = false;
        }
        boolean result = true;
        try {
            this.oObj.startDocument();
        }
        catch (SAXException e) {
            e.printStackTrace(this.log);
            this.log.println("Wrapped exception :" + e.WrappedException);
            result = false;
        }
        this.tRes.tested("startDocument()", result);
    }

    public void _endDocument() {
        if (this.ToBeSkipped) {
            this.tRes.tested("endDocument()", Status.skipped(true));
            return;
        }
        this.requiredMethod("startElement()");
        this.executeMethod("endElement()");
        this.executeMethod("characters()");
        this.executeMethod("ignorableWhitespace()");
        this.executeMethod("processingInstruction()");
        boolean result = true;
        try {
            this.oObj.endDocument();
        }
        catch (SAXException e) {
            e.printStackTrace(this.log);
            this.log.println("Wrapped exception :" + e.WrappedException);
            result = false;
        }
        this.log.println("Check if import was successful ...");
        this.tRes.tested("endDocument()", result &= this.checker.checkImport());
    }

    public void _startElement() {
        if (this.ToBeSkipped) {
            this.tRes.tested("startElement()", Status.skipped(true));
            return;
        }
        boolean result = true;
        try {
            this.log.println("StartElement Processing XML data ...");
            for (int i = 0; i < this.xmlData.length; ++i) {
                String[] elem = this.xmlData[i];
                String xmlTag = "";
                if ("start".equals(elem[0])) {
                    xmlTag = xmlTag + "<";
                    String tagName = elem[1];
                    xmlTag = xmlTag + tagName;
                    XMLTools.AttributeList attr = new XMLTools.AttributeList();
                    for (int j = 2; j < elem.length; j += 3) {
                        attr.add(elem[j], elem[j + 1], elem[j + 2]);
                        xmlTag = xmlTag + " " + elem[j] + "(" + elem[j + 1] + ")=\"" + elem[j + 2] + "\"";
                    }
                    xmlTag = xmlTag + ">";
                    this.log.println(xmlTag);
                    this.oObj.startElement(tagName, attr);
                    continue;
                }
                if ("end".equals(elem[0])) {
                    this.log.println("</" + elem[1] + ">");
                    this.oObj.endElement(elem[1]);
                    continue;
                }
                if ("chars".equals(elem[0])) {
                    this.log.println("'" + elem[1] + "'");
                    this.oObj.characters(elem[1]);
                    continue;
                }
                if ("spaces".equals(elem[0])) {
                    this.log.println("(spaces)'" + elem[1] + "'");
                    this.oObj.ignorableWhitespace(elem[1]);
                    continue;
                }
                if ("instruct".equals(elem[0])) {
                    this.log.println("<?" + elem[1] + " " + elem[2] + "?>");
                    this.oObj.processingInstruction(elem[1], elem[2]);
                    continue;
                }
                this.log.println("!!! Bad object relation !!!");
                throw new StatusException(Status.failed("Bad relation"));
            }
        }
        catch (SAXException e) {
            e.printStackTrace(this.log);
            this.log.println("Wrapped exception :" + e.WrappedException);
            result = false;
        }
        this.tRes.tested("startElement()", result);
    }

    public void _endElement() {
        if (this.ToBeSkipped) {
            this.tRes.tested("endElement()", Status.skipped(true));
            return;
        }
        this.requiredMethod("startElement()");
        boolean result = true;
        this.tRes.tested("endElement()", result);
    }

    public void _characters() {
        if (this.ToBeSkipped) {
            this.tRes.tested("characters()", Status.skipped(true));
            return;
        }
        this.requiredMethod("startElement()");
        boolean result = true;
        this.tRes.tested("characters()", result);
    }

    public void _ignorableWhitespace() {
        if (this.ToBeSkipped) {
            this.tRes.tested("ignorableWhitespace()", Status.skipped(true));
            return;
        }
        this.requiredMethod("startElement()");
        boolean result = true;
        this.tRes.tested("ignorableWhitespace()", result);
    }

    public void _processingInstruction() {
        if (this.ToBeSkipped) {
            this.tRes.tested("processingInstruction()", Status.skipped(true));
            return;
        }
        this.requiredMethod("startElement()");
        boolean result = true;
        this.tRes.tested("processingInstruction()", result);
    }

    public void _setDocumentLocator() {
        if (this.ToBeSkipped) {
            this.tRes.tested("setDocumentLocator()", Status.skipped(true));
            return;
        }
        this.executeMethod("endDocument()");
        boolean result = this.locatorResult;
        if (this.locatorException != null) {
            this.log.println("Exception occured during setDocumentLocator() call:");
            this.locatorException.printStackTrace(this.log);
            this.log.println("Wrapped exception :" + this.locatorException.WrappedException);
            result = false;
        }
        this.tRes.tested("setDocumentLocator()", result);
    }

    public static interface TargetDocumentSetter {
        public void setTargetDocument();
    }

    public static interface ImportChecker {
        public boolean checkImport();
    }

    private static class DocumentLocator
    implements XLocator {
        public boolean aMethodCalled = false;
        private PrintWriter log = null;

        public DocumentLocator(PrintWriter log) {
            this.log = log;
        }

        @Override
        public int getColumnNumber() {
            this.log.println("getColumnNumber() method called.");
            this.aMethodCalled = true;
            return 10;
        }

        @Override
        public int getLineNumber() {
            this.log.println("getLineNumber() method called.");
            this.aMethodCalled = true;
            return 9;
        }

        @Override
        public String getPublicId() {
            this.log.println("getPublicId() method called.");
            this.aMethodCalled = true;
            return "file://d:/file.txt";
        }

        @Override
        public String getSystemId() {
            this.log.println("getSystemId() method called.");
            this.aMethodCalled = true;
            return "system";
        }
    }
}

