/*
 * Decompiled with CFR 0.152.
 */
package ifc.view;

import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.view.XSelectionChangeListener;
import com.sun.star.view.XSelectionSupplier;
import java.util.Comparator;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.ValueComparer;

public class _XSelectionSupplier
extends MultiMethodTest {
    public XSelectionSupplier oObj = null;
    public boolean selectionChanged = false;
    Object[] selections = null;
    Comparator ObjCompare = null;
    XSelectionChangeListener listener = new MyChangeListener();

    @Override
    protected void before() {
        this.selections = (Object[])this.tEnv.getObjRelation("Selections");
        if (this.selections == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'Selections'"));
        }
        this.ObjCompare = (Comparator)this.tEnv.getObjRelation("Comparer");
    }

    @Override
    protected void after() {
        this.disposeEnvironment();
    }

    public void _addSelectionChangeListener() {
        boolean res = true;
        try {
            this.selectionChanged = false;
            this.oObj.addSelectionChangeListener(this.listener);
            this.oObj.select(this.selections[0]);
            this.oObj.select(this.selections[1]);
            res = this.selectionChanged;
        }
        catch (IllegalArgumentException ex) {
            this.log.println("Exception occured during addSelectionChangeListener()");
            ex.printStackTrace(this.log);
            res = false;
        }
        this.tRes.tested("addSelectionChangeListener()", res);
    }

    public void _select() {
        boolean res = true;
        boolean locRes = true;
        boolean compRes = true;
        Object oldSelection = null;
        try {
            for (int i = 0; i < this.selections.length; ++i) {
                oldSelection = this.oObj.getSelection();
                locRes = this.oObj.select(this.selections[i]);
                this.log.println("select #" + i + ": " + locRes);
                Object curSelection = this.oObj.getSelection();
                if (locRes) {
                    if (this.ObjCompare != null) {
                        this.ObjCompare.compare(this.selections[i], curSelection);
                    } else {
                        compRes = ValueComparer.equalValue(this.selections[i], curSelection);
                    }
                    this.log.println("selected object and current selection are equal: " + compRes);
                    if (!compRes && this.selections[i] instanceof Object[] && ((Object[])this.selections[i])[0] instanceof Integer) {
                        this.log.println("Getting: " + (Integer)((Object[])curSelection)[0]);
                        this.log.println("Expected: " + (Integer)((Object[])this.selections[i])[0]);
                    }
                    res &= compRes;
                    continue;
                }
                compRes = ValueComparer.equalValue(curSelection, oldSelection);
                this.log.println("previous selection and current selection are equal: " + compRes);
                res &= compRes;
            }
        }
        catch (IllegalArgumentException ex) {
            this.log.println("Exception occured during select()");
            ex.printStackTrace(this.log);
            res = false;
        }
        this.tRes.tested("select()", res);
    }

    public void _removeSelectionChangeListener() {
        boolean res = false;
        this.requiredMethod("addSelectionChangeListener()");
        try {
            this.selectionChanged = false;
            this.oObj.removeSelectionChangeListener(this.listener);
            this.oObj.select(this.selections[0]);
            this.oObj.select(this.selections[1]);
            res = !this.selectionChanged;
        }
        catch (IllegalArgumentException ex) {
            this.log.println("Exception occured during removeSelectionChangeListener()");
            ex.printStackTrace(this.log);
            res = false;
        }
        this.tRes.tested("removeSelectionChangeListener()", res);
    }

    public void _getSelection() {
        this.requiredMethod("select()");
        this.tRes.tested("getSelection()", true);
    }

    public class MyChangeListener
    implements XSelectionChangeListener {
        @Override
        public void disposing(EventObject oEvent) {
        }

        @Override
        public void selectionChanged(EventObject ev) {
            _XSelectionSupplier.this.log.println("listener called");
            _XSelectionSupplier.this.selectionChanged = true;
        }
    }
}

