/*
 * Decompiled with CFR 0.152.
 */
package ifc.view;

import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.view.XMultiSelectionSupplier;
import java.util.Comparator;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.ValueComparer;

public class _XMultiSelectionSupplier
extends MultiMethodTest {
    public XMultiSelectionSupplier oObj = null;
    public boolean selectionChanged = false;
    Object[] selections = null;
    Comparator ObjCompare = null;

    @Override
    protected void before() {
        this.selections = (Object[])this.tEnv.getObjRelation("Selections");
        if (this.selections == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'Selections'"));
        }
        this.ObjCompare = (Comparator)this.tEnv.getObjRelation("Comparer");
    }

    @Override
    protected void after() {
        this.disposeEnvironment();
    }

    public void _addSelection() {
        boolean bOK = true;
        this.log.println("clear selections");
        this.oObj.clearSelection();
        int count = this.oObj.getSelectionCount();
        if (!(bOK &= count == 0)) {
            this.log.println("ERROR: after clear selection I got a selection count of '" + count + "' => FAILED");
        }
        for (int i = 0; i < this.selections.length; ++i) {
            try {
                this.log.println("select object from object relation 'selections[" + i + "]'");
                this.oObj.addSelection(this.selections[i]);
            }
            catch (IllegalArgumentException ex) {
                this.log.println("ERROR: could not add selection from object relation 'selections[" + i + "]': " + ex.toString());
                bOK = false;
            }
            count = this.oObj.getSelectionCount();
            if (count == i + 1) continue;
            this.log.println("ERROR: add a selection but selection count (" + count + ") " + "is not as expected (" + (i + 1) + ") => FAILED");
            bOK = false;
        }
        this.log.println("try to select object relation 'selections[0]' second time...");
        try {
            count = this.oObj.getSelectionCount();
            this.oObj.addSelection(this.selections[0]);
        }
        catch (IllegalArgumentException ex) {
            this.log.println("ERROR: could not add selection from object relation 'selections[0] a second time': " + ex.toString());
        }
        if (count != this.oObj.getSelectionCount()) {
            this.log.println("ERROR: the selected count (" + this.oObj.getSelectionCount() + ") is not that before (" + count + ")");
            bOK = false;
        }
        this.log.println("try to select invalid object...");
        try {
            this.oObj.addSelection(this.oObj);
            this.log.println("ERORR: expected exception 'com.sun.star.lang.IllegalArgumentException' was not thrown => FAILED");
            bOK = false;
        }
        catch (IllegalArgumentException ex) {
            this.log.println("expected exception 'com.sun.star.lang.IllegalArgumentException' => OK");
        }
        this.tRes.tested("addSelection()", bOK);
    }

    public void _removeSelection() {
        this.requiredMethod("addSelection()");
        boolean bOK = true;
        this.log.println("clear selections");
        this.oObj.clearSelection();
        int count = this.oObj.getSelectionCount();
        if (!(bOK &= count == 0)) {
            this.log.println("ERROR: after clear selection I got a selection count of '" + count + "' => FAILED");
        }
        this.log.println("add some selections...");
        for (int i = 0; i < this.selections.length; ++i) {
            try {
                this.log.println("select object from object relation 'selections[" + i + "]'");
                this.oObj.addSelection(this.selections[i]);
            }
            catch (IllegalArgumentException ex) {
                this.log.println("ERROR: could not add selection from object relation 'selections[" + i + "]': " + ex.toString());
                bOK = false;
            }
            count = this.oObj.getSelectionCount();
            if (count == i + 1) continue;
            this.log.println("ERROR: added a selection but selection count (" + count + ") " + "is not as expected (" + (i + 1) + ") => FAILED");
            bOK = false;
        }
        this.log.println("try now to remove selections...");
        count = this.oObj.getSelectionCount();
        int oldCount = this.oObj.getSelectionCount();
        for (int i = 0; i < this.selections.length; ++i) {
            try {
                this.log.println("remove selection for object relation 'selections[" + i + "]'");
                this.oObj.removeSelection(this.selections[i]);
            }
            catch (IllegalArgumentException ex) {
                this.log.println("ERROR: could not remove selection from object relation 'selections[" + i + "]': " + ex.toString());
                bOK = false;
            }
            count = this.oObj.getSelectionCount();
            if (count == oldCount - i - 1) continue;
            this.log.println("ERROR: removed a selection but selection count (" + count + ") " + "is not as expected (" + (oldCount - i - 1) + ") => FAILED");
            bOK = false;
        }
        this.log.println("try to remove a removed selection a second time...");
        count = this.oObj.getSelectionCount();
        try {
            this.oObj.removeSelection(this.selections[0]);
        }
        catch (IllegalArgumentException ex) {
            this.log.println("ERROR: could not remove selection from object relation 'selections[0] a second time': " + ex.toString());
        }
        if (count != this.oObj.getSelectionCount()) {
            this.log.println("ERROR: the selected count (" + this.oObj.getSelectionCount() + ") is not that before (" + count + ")");
            bOK = false;
        }
        this.log.println("try to remove invalid object...");
        try {
            this.oObj.removeSelection(this.oObj);
            this.log.println("ERORR: expected exception 'com.sun.star.lang.IllegalArgumentException' was not thrown => FAILED");
            bOK = false;
        }
        catch (IllegalArgumentException ex) {
            this.log.println("expected exception 'com.sun.star.lang.IllegalArgumentException' => OK");
        }
        this.tRes.tested("removeSelection()", bOK);
    }

    public void _getSelectionCount() {
        this.requiredMethod("addSelection()");
        this.tRes.tested("getSelectionCount()", true);
    }

    public void _clearSelection() {
        this.requiredMethod("addSelection()");
        boolean bOK = true;
        this.log.println("clear selections");
        this.oObj.clearSelection();
        int count = this.oObj.getSelectionCount();
        if (!(bOK &= count == 0)) {
            this.log.println("ERROR: after clear selection I got a selection count of '" + count + "' => FAILED");
        }
        this.log.println("add some selections...");
        for (int i = 0; i < this.selections.length; ++i) {
            try {
                this.log.println("select object from object relation 'selections[" + i + "]'");
                this.oObj.addSelection(this.selections[i]);
            }
            catch (IllegalArgumentException ex) {
                this.log.println("ERROR: could not add selection from object relation 'selections[" + i + "]': " + ex.toString());
                bOK = false;
            }
            count = this.oObj.getSelectionCount();
            if (count == i + 1) continue;
            this.log.println("ERROR: added a selection but selection count (" + count + ") " + "is not as expected (" + (i + 1) + ") => FAILED");
            bOK = false;
        }
        count = this.oObj.getSelectionCount();
        this.log.println("clear selections...");
        this.oObj.clearSelection();
        count = this.oObj.getSelectionCount();
        if (!(bOK &= count == 0)) {
            this.log.println("ERROR: after clear selection I got a selection count of '" + count + "' => FAILED");
        }
        this.tRes.tested("clearSelection()", bOK);
    }

    public void _createSelectionEnumeration() {
        this.requiredMethod("addSelection()");
        boolean bOK = true;
        this.log.println("clear selections");
        this.oObj.clearSelection();
        int count = this.oObj.getSelectionCount();
        if (!(bOK &= count == 0)) {
            this.log.println("ERROR: after clear selection I got a selection count of '" + count + "' => FAILED");
        }
        this.log.println("add some selections...");
        for (int i = 0; i < this.selections.length; ++i) {
            try {
                this.log.println("select object from object relation 'selections[" + i + "]'");
                this.oObj.addSelection(this.selections[i]);
            }
            catch (IllegalArgumentException ex) {
                this.log.println("ERROR: could not add selection from object relation 'selections[" + i + "]': " + ex.toString());
                bOK = false;
            }
            count = this.oObj.getSelectionCount();
            if (count == i + 1) continue;
            this.log.println("ERROR: added a selection but selection count (" + count + ") " + "is not as expected (" + (i + 1) + ") => FAILED");
            bOK = false;
        }
        this.log.println("create enumeration...");
        XEnumeration xEnum = this.oObj.createSelectionEnumeration();
        boolean compRes = true;
        int i = 0;
        while (xEnum.hasMoreElements()) {
            this.log.println("try to get first element..");
            Object nextElement = null;
            try {
                nextElement = xEnum.nextElement();
            }
            catch (WrappedTargetException ex) {
                this.log.println("ERROR: could not get nextElement: " + ex.toString());
                bOK = false;
            }
            catch (NoSuchElementException ex) {
                this.log.println("ERROR: could not get nextElement: " + ex.toString());
                bOK = false;
            }
            Object shouldElement = this.selections[i];
            ++i;
            if (this.ObjCompare != null) {
                this.ObjCompare.compare(shouldElement, nextElement);
            } else {
                compRes = ValueComparer.equalValue(shouldElement, nextElement);
            }
            this.log.println("nextElement()-object and expected object 'selections[" + i + "]' are equal: " + compRes);
            if (!compRes && this.selections[i] instanceof Object[] && ((Object[])this.selections[i])[0] instanceof Integer) {
                this.log.println("Getting: " + (Integer)((Object[])shouldElement)[0]);
                this.log.println("Expected: " + (Integer)((Object[])this.selections[i])[0]);
            }
            bOK &= compRes;
        }
        this.tRes.tested("createSelectionEnumeration()", bOK);
    }

    public void _createReverseSelectionEnumeration() {
        this.requiredMethod("addSelection()");
        boolean bOK = true;
        this.log.println("clear selections");
        this.oObj.clearSelection();
        int count = this.oObj.getSelectionCount();
        if (!(bOK &= count == 0)) {
            this.log.println("ERROR: after clear selection I got a selection count of '" + count + "' => FAILED");
        }
        this.log.println("add some selections...");
        for (int i = 0; i < this.selections.length; ++i) {
            try {
                this.log.println("select object from object relation 'selections[" + i + "]'");
                this.oObj.addSelection(this.selections[i]);
            }
            catch (IllegalArgumentException ex) {
                this.log.println("ERROR: could not add selection from object relation 'selections[" + i + "]': " + ex.toString());
                bOK = false;
            }
            count = this.oObj.getSelectionCount();
            if (count == i + 1) continue;
            this.log.println("ERROR: added a selection but selection count (" + count + ") " + "is not as expected (" + (i + 1) + ") => FAILED");
            bOK = false;
        }
        this.log.println("create enumeration...");
        XEnumeration xEnum = this.oObj.createSelectionEnumeration();
        boolean compRes = true;
        int i = this.selections.length - 1;
        while (xEnum.hasMoreElements()) {
            this.log.println("try to get first element..");
            Object nextElement = null;
            try {
                nextElement = xEnum.nextElement();
            }
            catch (WrappedTargetException ex) {
                this.log.println("ERROR: could not get nextElement: " + ex.toString());
                bOK = false;
            }
            catch (NoSuchElementException ex) {
                this.log.println("ERROR: could not get nextElement: " + ex.toString());
                bOK = false;
            }
            Object shouldElement = this.selections[i];
            --i;
            if (this.ObjCompare != null) {
                this.ObjCompare.compare(shouldElement, nextElement);
            } else {
                compRes = ValueComparer.equalValue(shouldElement, nextElement);
            }
            this.log.println("nextElement()-object and expected object 'selections[" + i + "]' are equal: " + compRes);
            if (!compRes && this.selections[i] instanceof Object[] && ((Object[])this.selections[i])[0] instanceof Integer) {
                this.log.println("Getting: " + (Integer)((Object[])shouldElement)[0]);
                this.log.println("Expected: " + (Integer)((Object[])this.selections[i])[0]);
            }
            bOK &= compRes;
        }
        this.tRes.tested("createReverseSelectionEnumeration()", bOK);
    }
}

