/*
 * Decompiled with CFR 0.152.
 */
package ifc.util;

import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import lib.MultiMethodTest;

public class _XURLTransformer
extends MultiMethodTest {
    public XURLTransformer oObj = null;
    URL url;
    static final String user = "user";
    static final String invalidUserPrefix = "1";
    static final String password = "password";
    static final String server = "server";
    static final String invalidServerPrefix = "1";
    static final String port = "8080";
    static final String path = "/pub/path";
    static final String name = "file.txt";
    static final String arguments = "a=b";
    static final String mark = "mark";
    static final String expectedCompleteHTTP = "http://server:8080/pub/path/file.txt?a=b#mark";
    static final String expectedCompleteFTP = "ftp://user:password@server:8080/pub/path/file.txt";

    public void _assemble() {
        URL[] url = new URL[]{new URL()};
        url[0].Protocol = "http://";
        url[0].Server = server;
        url[0].Port = new Integer(port).shortValue();
        url[0].Path = path;
        url[0].Name = name;
        url[0].Arguments = arguments;
        url[0].Mark = mark;
        url[0].Main = "http://server:8080/pub/path/file.txt";
        boolean res = true;
        this.log.print("assemble http-URL: ");
        boolean complete = this.oObj.assemble(url);
        this.log.println(complete);
        res &= complete;
        if (!expectedCompleteHTTP.equals(url[0].Complete)) {
            this.log.println("assemble works wrong");
            this.log.println("complete field : " + url[0].Complete);
            this.log.println("expected : http://server:8080/pub/path/file.txt?a=b#mark");
            res = false;
        }
        url[0] = new URL();
        url[0].Protocol = "ftp://";
        url[0].User = user;
        url[0].Password = password;
        url[0].Server = server;
        url[0].Port = new Integer(port).shortValue();
        url[0].Path = path;
        url[0].Name = name;
        url[0].Main = expectedCompleteFTP;
        this.log.print("assemble ftp-URL: ");
        complete = this.oObj.assemble(url);
        this.log.println(complete);
        res &= complete;
        if (!expectedCompleteFTP.equals(url[0].Complete)) {
            this.log.println("assemble works wrong");
            this.log.println("complete field : " + url[0].Complete);
            this.log.println("expected : ftp://user:password@server:8080/pub/path/file.txt");
            res = false;
        }
        URL[] incompleteUrl = new URL[]{new URL()};
        incompleteUrl[0].Server = server;
        this.log.print("assemble incomplete URL: ");
        complete = this.oObj.assemble(incompleteUrl);
        this.log.println(complete);
        this.tRes.tested("assemble()", res &= !complete);
    }

    public void _parseStrict() {
        URL[] url = new URL[]{new URL()};
        url[0].Complete = expectedCompleteHTTP;
        boolean res = true;
        this.log.print("parseStrict(http://server:8080/pub/path/file.txt?a=b#mark): ");
        boolean complete = this.oObj.parseStrict(url);
        this.log.println(complete);
        res &= complete;
        if (!url[0].Protocol.equals("http://")) {
            this.log.println("parseStrict works wrong");
            this.log.println("protocol field : " + url[0].Protocol);
            this.log.println("expected : http://");
            res = false;
        }
        if (!url[0].Server.equals(server)) {
            this.log.println("parseStrict works wrong");
            this.log.println("server field : " + url[0].Server);
            this.log.println("expected : server");
            res = false;
        }
        if (url[0].Port != new Integer(port).shortValue()) {
            this.log.println("parseStrict works wrong");
            this.log.println("port field : " + url[0].Port);
            this.log.println("expected : 8080");
            res = false;
        }
        if (!url[0].Path.equals(path) && !url[0].Path.equals("/pub/path/")) {
            this.log.println("parseStrict works wrong");
            this.log.println("path field : " + url[0].Path);
            this.log.println("expected : /pub/path");
            res = false;
        }
        if (!url[0].Name.equals(name)) {
            this.log.println("parseStrict works wrong");
            this.log.println("name field : " + url[0].Name);
            this.log.println("expected : file.txt");
            res = false;
        }
        if (!url[0].Arguments.equals(arguments)) {
            this.log.println("parseStrict works wrong");
            this.log.println("arguments field : " + url[0].Arguments);
            this.log.println("expected : a=b");
            res = false;
        }
        if (!url[0].Mark.equals(mark)) {
            this.log.println("parseStrict works wrong");
            this.log.println("mark field : " + url[0].Mark);
            this.log.println("expected : mark");
            res = false;
        }
        url[0] = new URL();
        url[0].Complete = expectedCompleteFTP;
        this.log.print("parseStrict(ftp://user:password@server:8080/pub/path/file.txt): ");
        complete = this.oObj.parseStrict(url);
        this.log.println(complete);
        res &= complete;
        if (!url[0].Protocol.equals("ftp://")) {
            this.log.println("parseStrict works wrong");
            this.log.println("protocol field : " + url[0].Protocol);
            this.log.println("expected : ftp://");
            res = false;
        }
        if (!url[0].User.equals(user)) {
            this.log.println("parseStrict works wrong");
            this.log.println("user field : " + url[0].User);
            this.log.println("expected : user");
            res = false;
        }
        if (!url[0].Password.equals(password)) {
            this.log.println("parseStrict works wrong");
            this.log.println("password field : " + url[0].Password);
            this.log.println("expected : password");
            res = false;
        }
        if (!url[0].Server.equals(server)) {
            this.log.println("parseStrict works wrong");
            this.log.println("server field : " + url[0].Server);
            this.log.println("expected : server");
            res = false;
        }
        if (url[0].Port != new Integer(port).shortValue()) {
            this.log.println("parseStrict works wrong");
            this.log.println("port field : " + url[0].Port);
            this.log.println("expected : 8080");
            res = false;
        }
        if (!url[0].Path.equals(path) && !url[0].Path.equals("/pub/path/")) {
            this.log.println("parseStrict works wrong");
            this.log.println("path field : " + url[0].Path);
            this.log.println("expected : /pub/path");
            res = false;
        }
        if (!url[0].Name.equals(name)) {
            this.log.println("parseStrict works wrong");
            this.log.println("name field : " + url[0].Name);
            this.log.println("expected : file.txt");
            res = false;
        }
        URL[] incompleteUrl = new URL[]{new URL()};
        incompleteUrl[0].Complete = server;
        this.log.print("parseStrict(server): ");
        complete = this.oObj.parseStrict(incompleteUrl);
        this.log.println(complete);
        this.tRes.tested("parseStrict()", res &= !complete);
    }

    public void _parseSmart() {
        URL[] url = new URL[1];
        String httpURL = "1server:8080/pub/path/file.txt?a=b#mark";
        url[0] = new URL();
        url[0].Complete = httpURL;
        boolean res = true;
        this.log.print("parseSmart('" + httpURL + "', 'http://'): ");
        boolean complete = this.oObj.parseSmart(url, "http://");
        this.log.println(complete);
        res &= complete;
        if (!url[0].Protocol.equals("http://")) {
            this.log.println("parseSmart works wrong");
            this.log.println("protocol field : " + url[0].Protocol);
            this.log.println("expected : http://");
            res = false;
        }
        if (!url[0].Server.equals("1server")) {
            this.log.println("parseSmart works wrong");
            this.log.println("server field : " + url[0].Server);
            this.log.println("expected : server");
            res = false;
        }
        if (url[0].Port != new Integer(port).shortValue()) {
            this.log.println("parseSmart works wrong");
            this.log.println("port field : " + url[0].Port);
            this.log.println("expected : 8080");
            res = false;
        }
        if (!url[0].Path.equals(path) && !url[0].Path.equals("/pub/path/")) {
            this.log.println("parseSmart works wrong");
            this.log.println("path field : " + url[0].Path);
            this.log.println("expected : /pub/path");
            res = false;
        }
        if (!url[0].Name.equals(name)) {
            this.log.println("parseSmart works wrong");
            this.log.println("name field : " + url[0].Name);
            this.log.println("expected : file.txt");
            res = false;
        }
        if (!url[0].Arguments.equals(arguments)) {
            this.log.println("parseSmart works wrong");
            this.log.println("arguments field : " + url[0].Arguments);
            this.log.println("expected : a=b");
            res = false;
        }
        if (!url[0].Mark.equals(mark)) {
            this.log.println("parseSmart works wrong");
            this.log.println("mark field : " + url[0].Mark);
            this.log.println("expected : mark");
            res = false;
        }
        String ftpURL = "1user:password@server:8080/pub/path/file.txt";
        url[0] = new URL();
        url[0].Complete = ftpURL;
        this.log.print("parseSmart('" + ftpURL + "', 'ftp://'): ");
        complete = this.oObj.parseSmart(url, "ftp://");
        this.log.println(complete);
        res &= complete;
        if (!url[0].Protocol.equals("ftp://")) {
            this.log.println("parseSmart works wrong");
            this.log.println("protocol field : " + url[0].Protocol);
            this.log.println("expected : ftp://");
            res = false;
        }
        if (!url[0].User.equals("1user")) {
            this.log.println("parseSmart works wrong");
            this.log.println("user field : " + url[0].User);
            this.log.println("expected : user");
            res = false;
        }
        if (!url[0].Password.equals(password)) {
            this.log.println("parseSmart works wrong");
            this.log.println("password field : " + url[0].Password);
            this.log.println("expected : password");
            res = false;
        }
        if (!url[0].Server.equals(server)) {
            this.log.println("parseSmart works wrong");
            this.log.println("server field : " + url[0].Server);
            this.log.println("expected : server");
            res = false;
        }
        if (url[0].Port != new Integer(port).shortValue()) {
            this.log.println("parseSmart works wrong");
            this.log.println("port field : " + url[0].Port);
            this.log.println("expected : 8080");
            res = false;
        }
        if (!url[0].Path.equals(path) && !url[0].Path.equals("/pub/path/")) {
            this.log.println("parseSmart works wrong");
            this.log.println("path field : " + url[0].Path);
            this.log.println("expected : /pub/path");
            res = false;
        }
        if (!url[0].Name.equals(name)) {
            this.log.println("parseSmart works wrong");
            this.log.println("name field : " + url[0].Name);
            this.log.println("expected : file.txt");
            res = false;
        }
        this.tRes.tested("parseSmart()", res);
    }

    public void _getPresentation() {
        String incorrectURL;
        URL url = new URL();
        url.Complete = expectedCompleteHTTP;
        this.log.println("getPresentation('http://server:8080/pub/path/file.txt?a=b#mark', true): ");
        String presentation = this.oObj.getPresentation(url, true);
        boolean res = presentation.equals(expectedCompleteHTTP);
        this.log.println("Resulted presentation: " + presentation);
        this.log.println("Expected presentation: http://server:8080/pub/path/file.txt?a=b#mark");
        this.log.println("Result: " + res);
        url.Complete = expectedCompleteFTP;
        this.log.println("getPresentation('ftp://user:password@server:8080/pub/path/file.txt', false): ");
        String asterix = "";
        for (int n = 0; n < password.length(); ++n) {
            asterix = asterix + "*";
        }
        asterix = "<" + asterix.substring(1, asterix.length());
        asterix = asterix.substring(0, asterix.length() - 1) + ">";
        presentation = this.oObj.getPresentation(url, false);
        String expectedPresentation = "ftp://user:" + asterix + "@" + server + ":" + port + path + "/" + name;
        this.log.println("Resulted presentation: " + presentation);
        this.log.println("Expected presentation: " + expectedPresentation);
        this.log.println("Result: " + (res &= presentation.equals(expectedPresentation)));
        this.log.println("getPresentation('ftp://user:password@server:8080/pub/path/file.txt', true): ");
        presentation = this.oObj.getPresentation(url, true);
        expectedPresentation = expectedCompleteFTP;
        this.log.println("Resulted presentation: " + presentation);
        this.log.println("Expected presentation: " + expectedPresentation);
        this.log.println("Result: " + (res &= presentation.equals(expectedPresentation)));
        url.Complete = incorrectURL = "*bla-bla*";
        this.log.println("getPresentation('" + incorrectURL + "', false): ");
        presentation = this.oObj.getPresentation(url, false);
        expectedPresentation = "";
        this.log.println("Resulted presentation: " + presentation);
        this.log.println("Expected presentation: " + expectedPresentation);
        this.log.println("Result: " + (res &= presentation.equals(expectedPresentation)));
        this.tRes.tested("getPresentation()", res);
    }
}

