/*
 * Decompiled with CFR 0.152.
 */
package ifc.util;

import com.sun.star.beans.PropertyValue;
import com.sun.star.table.TableSortField;
import com.sun.star.table.TableSortFieldType;
import com.sun.star.util.XSortable;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XSortable
extends MultiMethodTest {
    public XSortable oObj = null;
    XSortChecker checker = null;
    PropertyValue[] oPV = null;

    @Override
    protected void before() {
        this.checker = (XSortChecker)this.tEnv.getObjRelation("SORTCHECKER");
        if (this.checker == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'SORTCHECKER'"));
        }
        this.checker.setPrintWriter(this.log);
    }

    public void _createSortDescriptor() {
        boolean bResult = false;
        this.log.println("test for createSortDescriptor() ");
        this.oPV = this.oObj.createSortDescriptor();
        if (this.oPV.length > 0) {
            bResult = true;
            for (int k = 0; k < this.oPV.length; ++k) {
                this.log.println("DescriptorProperty " + k + ": Name=" + this.oPV[k].Name + "; Value=" + this.oPV[k].Value);
                if (!this.oPV[k].Name.equals("SortFields")) continue;
                TableSortField[] tsf = (TableSortField[])this.oPV[k].Value;
                for (int l = 0; l < tsf.length; ++l) {
                    this.log.println("\t isAscending:  " + tsf[l].IsAscending);
                    this.log.println("\t IsCaseSensitive:  " + tsf[l].IsCaseSensitive);
                    this.log.println("\t CollatorAlgorithm:  " + tsf[l].CollatorAlgorithm);
                }
            }
        }
        this.log.println("Found " + this.oPV.length + " PropertyValues");
        this.tRes.tested("createSortDescriptor()", bResult);
    }

    public void _sort() {
        this.checker.prepareToSort();
        this.log.println("############## Sort algorithm: Alphanumeric Order: Ascending");
        this.modifyDescriptor(false, true);
        this.oObj.sort(this.oPV);
        boolean res = this.checker.checkSort(false, true);
        this.log.println("############################################################");
        this.log.println("############# Sort algorithm: Alphanumeric Order: Descending");
        this.modifyDescriptor(false, false);
        this.oObj.sort(this.oPV);
        res = this.checker.checkSort(false, false);
        this.log.println("############################################################");
        this.log.println("################# Sort algorithm: Numeric Order: Ascending");
        this.modifyDescriptor(true, true);
        this.oObj.sort(this.oPV);
        res = this.checker.checkSort(true, true);
        this.log.println("############################################################");
        this.log.println("################## Sort algorithm: Numeric Order: Descending");
        this.modifyDescriptor(true, false);
        this.oObj.sort(this.oPV);
        res = this.checker.checkSort(true, false);
        this.log.println("############################################################");
        this.tRes.tested("sort()", res);
    }

    protected void modifyDescriptor(boolean isSortNumeric, boolean isSortAscending) {
        for (int i = 0; i < this.oPV.length; ++i) {
            if (this.oPV[i].Name.equals("SortFields")) {
                TableSortField[] TableFields = (TableSortField[])this.oPV[i].Value;
                if (TableFields.length == 0) {
                    TableFields = new TableSortField[]{new TableSortField()};
                }
                for (int k = 0; k < TableFields.length; ++k) {
                    TableFields[k].IsAscending = isSortAscending;
                    if (isSortNumeric) {
                        TableFields[k].FieldType = TableSortFieldType.NUMERIC;
                        TableFields[k].CollatorAlgorithm = "numeric";
                        continue;
                    }
                    TableFields[k].FieldType = TableSortFieldType.ALPHANUMERIC;
                    TableFields[k].CollatorAlgorithm = "alphanumeric";
                }
                this.oPV[i].Value = TableFields;
            }
            if (this.oPV[i].Name.equals("isSortInTable")) {
                this.oPV[i].Value = new Boolean(true);
            }
            if (!this.oPV[i].Name.equals("IsSortColumns")) continue;
            this.oPV[i].Value = new Boolean(false);
        }
        this.log.println("Modified sort descriptor: ");
        if (this.oPV.length > 0) {
            for (int k = 0; k < this.oPV.length; ++k) {
                this.log.println("DescriptorProperty " + k + ": Name=" + this.oPV[k].Name + "; Value=" + this.oPV[k].Value);
                if (!this.oPV[k].Name.equals("SortFields")) continue;
                TableSortField[] tsf = (TableSortField[])this.oPV[k].Value;
                for (int l = 0; l < tsf.length; ++l) {
                    this.log.println("\t isAscending:  " + tsf[l].IsAscending);
                    this.log.println("\t IsCaseSensitive:  " + tsf[l].IsCaseSensitive);
                    this.log.println("\t CollatorAlgorithm:  " + tsf[l].CollatorAlgorithm);
                }
            }
        }
    }

    @Override
    protected void after() {
        this.disposeEnvironment();
    }

    public static interface XSortChecker {
        public void prepareToSort();

        public boolean checkSort(boolean var1, boolean var2);

        public void setPrintWriter(PrintWriter var1);
    }
}

