/*
 * Decompiled with CFR 0.152.
 */
package ifc.uno;

import com.sun.star.uno.Exception;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.XNamingService;
import lib.MultiMethodTest;
import lib.StatusException;

public class _XNamingService
extends MultiMethodTest {
    public static XNamingService oObj = null;
    private XInterface regObject = null;

    @Override
    public void before() {
        this.regObject = (XInterface)this.tEnv.getObjRelation("XNamingService.RegisterObject");
        if (this.regObject == null) {
            throw new StatusException("Can't create object to register", new NullPointerException());
        }
    }

    public void _registerObject() throws StatusException {
        try {
            oObj.registerObject("MyFactory", this.regObject);
        }
        catch (Exception e) {
            this.log.println("Exception while registering object :" + e);
            this.tRes.tested("registerObject()", false);
            return;
        }
        this.tRes.tested("registerObject()", true);
    }

    public void _getRegisteredObject() {
        this.requiredMethod("registerObject()");
        try {
            Object getObject = oObj.getRegisteredObject("MyFactory");
            this.tRes.tested("getRegisteredObject()", this.regObject.equals(getObject));
        }
        catch (Exception e) {
            this.log.println("Exception calling method :" + e);
            this.tRes.tested("getRegisteredObject()", false);
            return;
        }
    }

    public void _revokeObject() {
        this.requiredMethod("registerObject()");
        this.executeMethod("getRegisteredObject()");
        try {
            oObj.revokeObject("MyFactory");
            this.log.println("Object was revoked");
        }
        catch (Exception e) {
            this.log.println("Exception revoking object :" + e);
            this.tRes.tested("revokeObject()", false);
        }
        boolean res = true;
        try {
            this.log.println("Trying to getRegistered object ...");
            Object objregObj = oObj.getRegisteredObject("MyFactory");
            this.log.println("No exception");
            if (res &= objregObj == null) {
                this.log.println("But NULL was returned");
            }
        }
        catch (Exception e) {
            this.log.println("Expected exception - OK");
        }
        this.tRes.tested("revokeObject()", res);
    }
}

