/*
 * Decompiled with CFR 0.152.
 */
package ifc.ui.dialogs;

import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ui.dialogs.FilePickerEvent;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.ui.dialogs.XFilePicker;
import com.sun.star.ui.dialogs.XFilePickerListener;
import com.sun.star.ui.dialogs.XFilePickerNotifier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XCancellable;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.utils;

public class _XFilePickerNotifier
extends MultiMethodTest {
    public XFilePickerNotifier oObj = null;
    private XFilePicker fps = null;
    private String dir1 = null;
    private String dir2 = null;
    ExecThread eThread = null;
    TestListener listener = new TestListener();

    @Override
    public void before() {
        this.fps = UnoRuntime.queryInterface(XFilePicker.class, (Object)this.oObj);
        if (this.fps == null) {
            this.log.println("The object doesnt implement XFilePicker");
            throw new StatusException(Status.failed("The object doesnt implement XFilePicker"));
        }
        XExecutableDialog exD = UnoRuntime.queryInterface(XExecutableDialog.class, (Object)this.tEnv.getTestObject());
        this.dir1 = utils.getOfficeTemp((XMultiServiceFactory)this.tParam.getMSF());
        this.dir2 = utils.getFullTestURL("");
        this.eThread = new ExecThread(exD);
    }

    public void _addFilePickerListener() {
        this.oObj.addFilePickerListener(this.listener);
        try {
            this.log.println("***** Setting DisplayDirectory to " + this.dir1);
            this.fps.setDisplayDirectory(this.dir1);
            this.log.println("***** Getting: " + this.fps.getDisplayDirectory());
            this.openDialog();
            this.log.println("***** Setting DisplayDirectory to " + this.dir2);
            this.fps.setDisplayDirectory(this.dir2);
            this.log.println("***** Getting: " + this.fps.getDisplayDirectory());
        }
        catch (IllegalArgumentException e) {
            this.log.println("!!! Exception changing dir !!!");
            e.printStackTrace(this.log);
        }
        this.shortWait();
        if (!this.listener.called) {
            this.log.println("Listener wasn't called :-(");
        }
        this.closeDialog();
        this.tRes.tested("addFilePickerListener()", this.listener.called);
    }

    public void _removeFilePickerListener() {
        this.requiredMethod("addFilePickerListener()");
        this.oObj.removeFilePickerListener(this.listener);
        this.listener.called = false;
        try {
            this.fps.setDisplayDirectory(this.dir1);
            this.openDialog();
            this.fps.setDisplayDirectory(this.dir2);
        }
        catch (IllegalArgumentException e) {
            this.log.println("!!! Exception changing dir !!!");
            e.printStackTrace(this.log);
        }
        this.shortWait();
        this.closeDialog();
        this.tRes.tested("removeFilePickerListener()", !this.listener.called);
    }

    private void shortWait() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }

    private void closeDialog() {
        XCancellable canc = UnoRuntime.queryInterface(XCancellable.class, (Object)this.tEnv.getTestObject());
        if (canc != null) {
            this.log.println("Cancelling Dialog");
            canc.cancel();
        } else {
            this.disposeEnvironment();
        }
        long st = System.currentTimeMillis();
        boolean toLong = false;
        this.log.println("waiting for dialog to close");
        while (this.eThread.isAlive() && !toLong) {
            toLong = System.currentTimeMillis() - st > 10000L;
        }
        this.log.println("done");
        try {
            if (this.eThread.isAlive()) {
                this.log.println("Interrupting Thread");
                this.eThread.interrupt();
                _XFilePickerNotifier _XFilePickerNotifier2 = this;
                _XFilePickerNotifier2.eThread.yield();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        st = System.currentTimeMillis();
        toLong = false;
        this.log.println("waiting for interruption to work");
        while (this.eThread.isAlive() && !toLong) {
            toLong = System.currentTimeMillis() - st > 10000L;
        }
        this.log.println("DialogThread alive: " + this.eThread.isAlive());
        this.log.println("done");
    }

    private void openDialog() {
        this.log.println("Starting Dialog");
        if (this.eThread.isAlive()) {
            this.log.println("second interrupt");
            this.eThread.interrupt();
            _XFilePickerNotifier _XFilePickerNotifier2 = this;
            _XFilePickerNotifier2.eThread.yield();
        }
        XExecutableDialog exD = UnoRuntime.queryInterface(XExecutableDialog.class, (Object)this.tEnv.getTestObject());
        this.dir1 = utils.getOfficeTemp((XMultiServiceFactory)this.tParam.getMSF());
        this.dir2 = utils.getFullTestURL("");
        this.eThread = new ExecThread(exD);
        this.eThread.start();
    }

    protected class ExecThread
    extends Thread {
        public short execRes = (short)17;
        private XExecutableDialog Diag = null;

        public ExecThread(XExecutableDialog Diag) {
            this.Diag = Diag;
        }

        @Override
        public void run() {
            try {
                this.execRes = this.Diag.execute();
                System.out.println("HERE: " + this.execRes);
            }
            catch (Exception e) {
                _XFilePickerNotifier.this.log.println("Thread has been interrupted ...");
            }
        }
    }

    protected class TestListener
    implements XFilePickerListener {
        public boolean called = false;

        protected TestListener() {
        }

        @Override
        public void dialogSizeChanged() {
            this.called = true;
        }

        @Override
        public void fileSelectionChanged(FilePickerEvent e) {
            this.called = true;
        }

        @Override
        public void directoryChanged(FilePickerEvent e) {
            _XFilePickerNotifier.this.log.println("***** Directory Changed *****");
            this.called = true;
        }

        @Override
        public String helpRequested(FilePickerEvent e) {
            this.called = true;
            return "help";
        }

        @Override
        public void controlStateChanged(FilePickerEvent e) {
            this.called = true;
        }

        @Override
        public void disposing(EventObject e) {
        }
    }
}

