/*
 * Decompiled with CFR 0.152.
 */
package ifc.ui.dialogs;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.ui.dialogs.XControlAccess;
import com.sun.star.ui.dialogs.XControlInformation;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.ValueChanger;
import util.ValueComparer;

public class _XControlAccess
extends MultiMethodTest {
    public XControlAccess oObj = null;
    private XControlInformation xCI = null;
    private String[] supControls = null;
    private String[][] supProperties = null;

    @Override
    protected void before() {
        this.xCI = UnoRuntime.queryInterface(XControlInformation.class, (Object)this.oObj);
        if (this.xCI == null) {
            throw new StatusException(Status.failed("XControlInformation not supported"));
        }
        this.supControls = this.xCI.getSupportedControls();
        this.supProperties = new String[this.supControls.length][];
        for (int i = 0; i < this.supControls.length; ++i) {
            try {
                this.supProperties[i] = this.xCI.getSupportedControlProperties(this.supControls[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace(this.log);
                throw new StatusException("Exception while init.", e);
            }
        }
    }

    public void _setControlProperty() {
        boolean result = true;
        String error = "";
        for (int i = 0; i < this.supControls.length; ++i) {
            this.log.println("Checking properties for control " + this.supControls[i]);
            for (int j = 0; j < this.supProperties[i].length; ++j) {
                this.log.println("\t" + this.supProperties[i][j]);
                try {
                    Object oldVal = this.oObj.getControlProperty(this.supControls[i], this.supProperties[i][j]);
                    Object newVal = ValueChanger.changePValue(oldVal);
                    if (this.supProperties[i][j].startsWith("Help")) {
                        newVal = "HID:133";
                    }
                    this.oObj.setControlProperty(this.supControls[i], this.supProperties[i][j], newVal);
                    Object resVal = this.oObj.getControlProperty(this.supControls[i], this.supProperties[i][j]);
                    this.log.println("\t Old:" + oldVal + ",New:" + newVal + ",Result:" + resVal);
                    if (!ValueComparer.equalValue(newVal, resVal)) {
                        error = error + "####Property '" + this.supProperties[i][j] + " of " + this.supControls[i] + " didn't work\n\r" + "\t Old:" + oldVal + ",New:" + newVal + ",Result:" + resVal + "\n\r";
                    }
                    result &= ValueComparer.equalValue(newVal, resVal);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.log.println("Unexpected exception:");
                    e.printStackTrace(this.log);
                    result = false;
                }
            }
        }
        this.log.println(error);
        this.tRes.tested("setControlProperty()", result);
        this.tRes.tested("getControlProperty()", result);
    }

    public void _getControlProperty() {
    }
}

