/*
 * Decompiled with CFR 0.152.
 */
package ifc.ui;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XIndexContainer;
import com.sun.star.lang.IllegalAccessException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.ui.XImageManager;
import com.sun.star.ui.XUIConfigurationManager;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import util.dbg;

public class _XUIConfigurationManager
extends MultiMethodTest {
    public XUIConfigurationManager oObj;
    private String msResourceUrl = "private:resource/menubar/menubar";
    private String msMyResourceUrl = "private:resource/menubar/mymenubar";
    private XIndexContainer mxSettings = null;
    private XIndexAccess mxMenuBarSettings = null;
    private XMultiServiceFactory mxMSF = null;
    private String sShortCutManagerServiceName = null;

    @Override
    protected void before() {
        this.mxMSF = (XMultiServiceFactory)this.tParam.getMSF();
        this.sShortCutManagerServiceName = (String)this.tEnv.getObjRelation("XConfigurationManager.ShortCutManager");
    }

    public void _reset() {
        this.requiredMethod("removeSettings()");
        this.oObj.reset();
        this.tRes.tested("reset()", true);
    }

    public void _getUIElementsInfo() {
        boolean result = true;
        try {
            PropertyValue[][] props = this.oObj.getUIElementsInfo((short)0);
            for (int i = 0; i < props.length; ++i) {
                for (int j = 0; j < props[i].length; ++j) {
                    this.log.println("Prop[" + i + "][" + j + "]: " + props[i][j].Name + "   " + props[i][j].Value.toString());
                }
            }
        }
        catch (IllegalArgumentException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        this.tRes.tested("getUIElementsInfo()", result);
    }

    public void _createSettings() {
        this.mxSettings = this.oObj.createSettings();
        dbg.printInterfaces(this.mxSettings);
        this.tRes.tested("createSettings()", this.mxSettings != null);
    }

    public void _hasSettings() {
        boolean result = false;
        try {
            result = this.oObj.hasSettings(this.msResourceUrl);
        }
        catch (IllegalArgumentException e) {
            this.log.println(e);
            result = false;
        }
        this.tRes.tested("hasSettings()", result);
    }

    public void _getSettings() {
        this.requiredMethod("hasSettings()");
        boolean result = true;
        try {
            this.mxMenuBarSettings = this.oObj.getSettings(this.msResourceUrl, true);
            result = this.mxMenuBarSettings != null;
            for (int i = 0; i < this.mxMenuBarSettings.getCount(); ++i) {
                Object[] o = (Object[])this.mxMenuBarSettings.getByIndex(i);
                this.log.println("+++++++++ i = " + i);
                for (int j = 0; j < o.length; ++j) {
                    PropertyValue prop = (PropertyValue)o[j];
                    this.log.println("Property" + j + ": " + prop.Name + "   " + prop.Value.toString());
                }
            }
        }
        catch (NoSuchElementException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        catch (IllegalArgumentException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        catch (IndexOutOfBoundsException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        catch (WrappedTargetException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        this.tRes.tested("getSettings()", result);
    }

    public void _replaceSettings() {
        this.requiredMethod("getSettings()");
        boolean result = true;
        PropertyValue[] prop = _XUIConfigurationManager.createMenuBarEntry("My Entry", this.mxMenuBarSettings, this.mxMSF, this.log);
        if (prop == null) {
            this.tRes.tested("replaceSettings()", false);
            return;
        }
        _XUIConfigurationManager.createMenuBarItem("Click for Macro", UnoRuntime.queryInterface(XIndexContainer.class, prop[3].Value), this.log);
        XIndexContainer x = UnoRuntime.queryInterface(XIndexContainer.class, (Object)this.mxMenuBarSettings);
        try {
            x.insertByIndex(x.getCount(), prop);
        }
        catch (IllegalArgumentException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        catch (IndexOutOfBoundsException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        catch (WrappedTargetException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        try {
            this.oObj.replaceSettings(this.msResourceUrl, this.mxMenuBarSettings);
        }
        catch (NoSuchElementException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        catch (IllegalArgumentException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        catch (IllegalAccessException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        this._getSettings();
        this.tRes.tested("replaceSettings()", result);
    }

    public void _removeSettings() {
        this.requiredMethod("insertSettings()");
        boolean result = true;
        try {
            this.oObj.removeSettings(this.msMyResourceUrl);
        }
        catch (NoSuchElementException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        catch (IllegalArgumentException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("removeSettings()", result);
    }

    public void _insertSettings() {
        this.requiredMethod("createSettings()");
        this.requiredMethod("replaceSettings()");
        boolean result = true;
        dbg.printInterfaces(this.mxSettings);
        PropertyValue[] prop = _XUIConfigurationManager.createMenuBarEntry("A new entry", this.mxSettings, this.mxMSF, this.log);
        if (prop == null) {
            this.tRes.tested("replaceSettings()", false);
            return;
        }
        _XUIConfigurationManager.createMenuBarItem("A new sub entry", UnoRuntime.queryInterface(XIndexContainer.class, prop[3].Value), this.log);
        XIndexContainer x = UnoRuntime.queryInterface(XIndexContainer.class, (Object)this.mxSettings);
        try {
            int count = x.getCount();
            x.insertByIndex(count, prop);
        }
        catch (IllegalArgumentException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        catch (IndexOutOfBoundsException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        catch (WrappedTargetException e) {
            result = false;
            e.printStackTrace(this.log);
        }
        try {
            this.oObj.insertSettings(this.msMyResourceUrl, this.mxSettings);
        }
        catch (ElementExistException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace(this.log);
            result = false;
        }
        this.tRes.tested("insertSettings()", result);
    }

    public void _getImageManager() {
        Object o = this.oObj.getImageManager();
        this.log.println("###### ImageManager ");
        XImageManager xImageManager = UnoRuntime.queryInterface(XImageManager.class, o);
        this.tRes.tested("getImageManager()", xImageManager != null);
    }

    public void _getShortCutManager() {
        Object o = this.oObj.getShortCutManager();
        XServiceInfo xSI = UnoRuntime.queryInterface(XServiceInfo.class, o);
        String[] serviceNames = xSI.getSupportedServiceNames();
        boolean bSupportedServiceFound = false;
        for (int i = 0; i < serviceNames.length; ++i) {
            this.log.println("SuppService: " + serviceNames[i]);
            if (!serviceNames[i].equals(this.sShortCutManagerServiceName)) continue;
            bSupportedServiceFound = true;
        }
        this.tRes.tested("getShortCutManager()", bSupportedServiceFound);
    }

    public void _getEventsManager() {
        Object o = this.oObj.getEventsManager();
        this.tRes.tested("getEventsManager()", o == null);
    }

    public static PropertyValue[] createMenuBarEntry(String sLabelName, XIndexAccess xMenuBarSettings, XMultiServiceFactory xMSF, PrintWriter log) {
        PropertyValue[] prop = new PropertyValue[4];
        prop[0] = new PropertyValue();
        prop[0].Name = "CommandURL";
        prop[0].Value = "vnd.openoffice.org:MyMenu";
        prop[1] = new PropertyValue();
        prop[1].Name = "Label";
        prop[1].Value = sLabelName;
        prop[2] = new PropertyValue();
        prop[2].Name = "Type";
        prop[2].Value = new Short(0);
        prop[3] = new PropertyValue();
        prop[3].Name = "ItemDescriptorContainer";
        XSingleComponentFactory xFactory = UnoRuntime.queryInterface(XSingleComponentFactory.class, (Object)xMenuBarSettings);
        try {
            XPropertySet xProp = UnoRuntime.queryInterface(XPropertySet.class, (Object)xMSF);
            XComponentContext xContext = UnoRuntime.queryInterface(XComponentContext.class, xProp.getPropertyValue("DefaultContext"));
            prop[3].Value = xFactory.createInstanceWithContext(xContext);
        }
        catch (Exception e) {
            log.println("Could not create an instance for ItemDescriptorContainer property.");
            e.printStackTrace(log);
            return null;
        }
        return prop;
    }

    public static void createMenuBarItem(String sLabelName, XIndexContainer xDescriptionContainer, PrintWriter log) {
        PropertyValue[] aMenuItem = new PropertyValue[3];
        aMenuItem[0] = new PropertyValue();
        aMenuItem[0].Name = "CommandURL";
        aMenuItem[0].Value = "macro:///Standard.Module1.Test()";
        aMenuItem[1] = new PropertyValue();
        aMenuItem[1].Name = "Label";
        aMenuItem[1].Value = sLabelName;
        aMenuItem[2] = new PropertyValue();
        aMenuItem[2].Name = "Type";
        aMenuItem[2].Value = new Short(0);
        try {
            xDescriptionContainer.insertByIndex(0, aMenuItem);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
        }
    }
}

