/*
 * Decompiled with CFR 0.152.
 */
package ifc.ui;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ui.XContextMenuInterception;
import com.sun.star.ui.XContextMenuInterceptor;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import helper.ContextMenuInterceptor;
import java.awt.AWTException;
import java.awt.Robot;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.AccessibilityTools;
import util.DesktopTools;
import util.utils;

public class _XContextMenuInterception
extends MultiMethodTest {
    private XModel docModel = null;
    private XContextMenuInterceptor xCI = null;
    public XContextMenuInterception oObj = null;
    private XWindow xWindow = null;
    private XMultiServiceFactory xMSF = null;
    private Point point = null;

    @Override
    public void before() {
        this.docModel = UnoRuntime.queryInterface(XModel.class, this.tEnv.getObjRelation("FirstModel"));
        this.xCI = UnoRuntime.queryInterface(XContextMenuInterceptor.class, (Object)new ContextMenuInterceptor());
        this.xMSF = (XMultiServiceFactory)this.tParam.getMSF();
        this.log.println("ensure that the first model is focused");
        DesktopTools.bringWindowToFront(this.docModel);
        utils.shortWait(3000);
    }

    @Override
    public void after() {
        if (this.xCI != null) {
            this.oObj.releaseContextMenuInterceptor(this.xCI);
        }
    }

    public void _registerContextMenuInterceptor() {
        this.oObj.registerContextMenuInterceptor(this.xCI);
        this.openContextMenu(this.docModel);
        boolean res = this.checkHelpEntry();
        this.releasePopUp();
        this.tRes.tested("registerContextMenuInterceptor()", res);
    }

    public void _releaseContextMenuInterceptor() {
        this.requiredMethod("registerContextMenuInterceptor()");
        this.oObj.releaseContextMenuInterceptor(this.xCI);
        this.openContextMenu(this.docModel);
        boolean res = this.checkHelpEntry();
        this.releasePopUp();
        this.tRes.tested("releaseContextMenuInterceptor()", !res);
    }

    private boolean checkHelpEntry() {
        XInterface toolkit = null;
        boolean res = true;
        this.log.println("get accesibility...");
        try {
            toolkit = (XInterface)this.xMSF.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            this.log.println("could not get Toolkit " + e.toString());
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)toolkit);
        XAccessible xRoot = null;
        AccessibilityTools at = new AccessibilityTools();
        try {
            this.xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)tk.getTopWindow(0));
            xRoot = AccessibilityTools.getAccessibleObject(this.xWindow);
            AccessibilityTools.printAccessibleTree(this.log, xRoot, this.tParam.getBool("DebugIsActive"));
        }
        catch (IndexOutOfBoundsException e) {
            this.log.println("Couldn't get Window");
        }
        XAccessibleContext oPopMenu = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)43, true);
        this.log.println("ImplementationName: " + utils.getImplName(oPopMenu));
        XAccessible xHelp = null;
        try {
            this.log.println("Try to get second entry of context menu...");
            xHelp = oPopMenu.getAccessibleChild(1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new StatusException("Not possible to get second entry of context menu", e);
        }
        if (xHelp == null) {
            throw new StatusException(new Status("second entry of context menu is NULL", false));
        }
        XAccessibleContext xHelpCont = xHelp.getAccessibleContext();
        if (xHelpCont == null) {
            throw new StatusException(new Status("No able to retrieve accessible context from first entry of context menu", false));
        }
        String aAccessibleName = xHelpCont.getAccessibleName();
        if (!aAccessibleName.equals("Help")) {
            this.log.println("Accessible name found = " + aAccessibleName);
            this.log.println("Second entry of context menu is not from context menu interceptor");
            res = false;
        }
        return res;
    }

    private void openContextMenu(XModel xModel) {
        this.log.println("try to open contex menu...");
        AccessibilityTools at = new AccessibilityTools();
        this.xWindow = AccessibilityTools.getCurrentWindow(this.xMSF, xModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(this.xWindow);
        XAccessibleContext oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)40);
        XAccessibleComponent window = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)oObj);
        this.point = window.getLocationOnScreen();
        Rectangle rect = window.getBounds();
        this.log.println("klick mouse button...");
        try {
            Robot rob = new Robot();
            int x = this.point.X + rect.Width / 2;
            int y = this.point.Y + rect.Height / 2;
            rob.mouseMove(x, y);
            System.out.println("Press Button");
            rob.mousePress(4);
            System.out.println("Release Button");
            rob.mouseRelease(4);
            System.out.println("done");
        }
        catch (AWTException e) {
            this.log.println("couldn't press mouse button");
        }
        utils.shortWait(1000);
    }

    private void releasePopUp() {
        this.log.println("release the popup menu");
        try {
            Robot rob = new Robot();
            int x = this.point.X;
            int y = this.point.Y;
            rob.mouseMove(x, y);
            rob.mousePress(16);
            rob.mouseRelease(16);
        }
        catch (AWTException e) {
            this.log.println("couldn't press mouse button");
        }
    }
}

