/*
 * Decompiled with CFR 0.152.
 */
package ifc.ucb;

import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.io.XStream;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.DateTime;
import java.io.File;
import java.util.Date;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;
import util.utils;

public class _XSimpleFileAccess
extends MultiMethodTest {
    public static XSimpleFileAccess oObj = null;

    public void _copy() {
        try {
            String copiedFile = "";
            String dirname = utils.getFullTestURL("XSimpleFileAccess");
            String dirnameTo = utils.getOfficeTemp((XMultiServiceFactory)this.tParam.getMSF());
            String filename = dirname + "XSimpleFileAccess.txt";
            copiedFile = dirnameTo + "XSimpleFileAccess_copy.txt";
            if (oObj.exists(copiedFile)) {
                oObj.kill(copiedFile);
            }
            oObj.copy(filename, copiedFile);
            this.tRes.tested("copy()", oObj.exists(copiedFile));
            oObj.kill(copiedFile);
        }
        catch (com.sun.star.uno.Exception ex) {
            this.log.println("Exception occured while testing 'copy()'");
            ex.printStackTrace(this.log);
            this.tRes.tested("copy()", false);
        }
    }

    public void _move() {
        try {
            String copiedFile = "";
            String dirname = utils.getFullTestURL("XSimpleFileAccess");
            String dirnameTo = utils.getOfficeTemp((XMultiServiceFactory)this.tParam.getMSF());
            String filename = dirname + "XSimpleFileAccess.txt";
            copiedFile = dirnameTo + "XSimpleFileAccess_copy.txt";
            if (oObj.exists(copiedFile)) {
                oObj.kill(copiedFile);
            }
            oObj.copy(filename, copiedFile);
            filename = copiedFile;
            copiedFile = dirnameTo + "XSimpleFileAccess_move.txt";
            oObj.move(filename, copiedFile);
            this.tRes.tested("move()", oObj.exists(copiedFile));
            oObj.kill(copiedFile);
        }
        catch (com.sun.star.uno.Exception ex) {
            this.log.println("Exception occured while testing 'move()'");
            ex.printStackTrace(this.log);
            this.tRes.tested("move()", false);
        }
    }

    public void _kill() {
        try {
            String copiedFile = "";
            String dirname = utils.getFullTestURL("XSimpleFileAccess");
            String dirnameTo = utils.getOfficeTemp((XMultiServiceFactory)this.tParam.getMSF());
            String filename = dirname + "XSimpleFileAccess.txt";
            copiedFile = dirnameTo + "XSimpleFileAccess_copy.txt";
            if (oObj.exists(copiedFile)) {
                oObj.kill(copiedFile);
            }
            oObj.copy(filename, copiedFile);
            oObj.kill(copiedFile);
            this.tRes.tested("kill()", !oObj.exists(copiedFile));
        }
        catch (com.sun.star.uno.Exception ex) {
            this.log.println("Exception occured while testing 'kill()'");
            ex.printStackTrace(this.log);
            this.tRes.tested("kill()", false);
        }
    }

    public void _isFolder() {
        try {
            String dirname = utils.getFullTestURL("XSimpleFileAccess");
            this.tRes.tested("isFolder()", oObj.isFolder(dirname));
        }
        catch (com.sun.star.uno.Exception ex) {
            this.log.println("Exception occured while testing 'isFolder()'");
            ex.printStackTrace(this.log);
            this.tRes.tested("isFolder()", false);
        }
    }

    public void _isReadOnly() {
        this.requiredMethod("setReadOnly()");
        try {
            String dirname = utils.getFullTestURL("XSimpleFileAccess");
            String filename = dirname + "XSimpleFileAccess.txt";
            boolean result = true;
            String dirnameTo = utils.getOfficeTemp((XMultiServiceFactory)this.tParam.getMSF());
            String readonlyCopy = dirnameTo + "XSimpleFileAccess_copy.txt";
            if (oObj.exists(readonlyCopy)) {
                oObj.kill(readonlyCopy);
            }
            oObj.copy(filename, readonlyCopy);
            oObj.setReadOnly(readonlyCopy, true);
            result &= oObj.isReadOnly(readonlyCopy);
            oObj.setReadOnly(readonlyCopy, false);
            boolean bl = !oObj.isReadOnly(readonlyCopy);
            oObj.kill(readonlyCopy);
            this.tRes.tested("isReadOnly()", result &= bl);
        }
        catch (com.sun.star.uno.Exception ex) {
            this.log.println("Exception occured while testing 'isReadOnly()'");
            ex.printStackTrace(this.log);
            this.tRes.tested("isReadOnly()", false);
        }
    }

    public void _setReadOnly() {
        boolean result = true;
        try {
            String dirname = utils.getFullTestURL("XSimpleFileAccess");
            String filename = dirname + "XSimpleFileAccess.txt";
            String dirnameTo = utils.getOfficeTemp((XMultiServiceFactory)this.tParam.getMSF());
            String readonlyCopy = dirnameTo + "XSimpleFileAccess_copy.txt";
            if (oObj.exists(readonlyCopy)) {
                oObj.kill(readonlyCopy);
            }
            oObj.copy(filename, readonlyCopy);
            oObj.setReadOnly(readonlyCopy, true);
            result &= oObj.isReadOnly(readonlyCopy);
            oObj.setReadOnly(readonlyCopy, false);
            this.tRes.tested("setReadOnly()", result &= !oObj.isReadOnly(readonlyCopy));
            oObj.kill(readonlyCopy);
        }
        catch (Exception ex) {
            this.log.println("Exception occured while testing 'setReadOnly()'");
            ex.printStackTrace(this.log);
            this.tRes.tested("setReadOnly()", false);
        }
    }

    public void _createFolder() {
        try {
            String tmpdirname = utils.getOfficeTemp((XMultiServiceFactory)this.tParam.getMSF());
            String newFolder = tmpdirname + "SimpleSubFolder";
            if (oObj.exists(newFolder)) {
                oObj.kill(newFolder);
            }
            oObj.createFolder(newFolder);
            this.tRes.tested("createFolder()", oObj.isFolder(newFolder));
            oObj.kill(newFolder);
        }
        catch (com.sun.star.uno.Exception ex) {
            this.log.println("Exception occured while testing 'createFolder()'");
            ex.printStackTrace(this.log);
            this.tRes.tested("createFolder()", false);
        }
    }

    public void _getSize() {
        try {
            String dirname = utils.getFullTestURL("XSimpleFileAccess");
            String filename = dirname + "XSimpleFileAccess.txt";
            int fSize = oObj.getSize(filename);
            this.tRes.tested("getSize()", fSize == 17);
        }
        catch (com.sun.star.uno.Exception ex) {
            this.log.println("Exception occured while testing 'getSize()'");
            ex.printStackTrace(this.log);
            this.tRes.tested("getSize()", false);
        }
    }

    public void _getContentType() {
        try {
            String dirname = utils.getFullTestURL("XSimpleFileAccess");
            String filename = dirname + "XSimpleFileAccess.txt";
            String fType = oObj.getContentType(filename);
            this.tRes.tested("getContentType()", "application/vnd.sun.staroffice.fsys-file".equals(fType));
        }
        catch (com.sun.star.uno.Exception ex) {
            this.log.println("Exception occured while testing 'getContentType()'");
            ex.printStackTrace(this.log);
            this.tRes.tested("getContentType()", false);
        }
    }

    public void _getDateTimeModified() {
        try {
            boolean partResult;
            String dirname = utils.getFullTestURL("XSimpleFileAccess");
            String filename = dirname + "XSimpleFileAccess.txt";
            DateTime fTime = oObj.getDateTimeModified(filename);
            File the_file = new File(filename);
            long lastModified = the_file.lastModified();
            Date lastMod = new Date(lastModified);
            boolean res = true;
            boolean bl = partResult = fTime.Day == lastMod.getDay();
            if (!partResult) {
                this.log.println("Wrong Day");
                this.log.println("Expected: " + lastMod.getDay());
                this.log.println("Gained: " + fTime.Day);
                this.log.println("------------------------------");
            }
            boolean bl2 = partResult = fTime.Month == lastMod.getMonth();
            if (!partResult) {
                this.log.println("Wrong Month");
                this.log.println("Expected: " + lastMod.getMonth());
                this.log.println("Gained: " + fTime.Month);
                this.log.println("------------------------------");
            }
            boolean bl3 = partResult = fTime.Year == lastMod.getYear();
            if (!partResult) {
                this.log.println("Wrong Year");
                this.log.println("Expected: " + lastMod.getYear());
                this.log.println("Gained: " + fTime.Year);
                this.log.println("------------------------------");
            }
            this.tRes.tested("getDateTimeModified()", res);
        }
        catch (com.sun.star.uno.Exception ex) {
            this.log.println("Exception occured while testing 'getDateTimeModified()'");
            ex.printStackTrace(this.log);
            this.tRes.tested("getDateTimeModified()", false);
        }
    }

    public void _getFolderContents() {
        try {
            String dirname = utils.getFullTestURL("XSimpleFileAccess");
            String[] cont = oObj.getFolderContents(dirname, false);
            this.tRes.tested("getFolderContents()", cont.length > 0);
        }
        catch (com.sun.star.uno.Exception ex) {
            this.log.println("Exception occured while testing 'getFolderContents()'");
            ex.printStackTrace(this.log);
            this.tRes.tested("getFolderContents()", false);
        }
    }

    public void _exists() {
        try {
            String dirname = utils.getFullTestURL("XSimpleFileAccess");
            String filename = dirname + "XSimpleFileAccess.txt";
            String wrongname = dirname + "I_do_not_exists.txt";
            this.tRes.tested("exists()", oObj.exists(filename) && !oObj.exists(wrongname));
        }
        catch (com.sun.star.uno.Exception ex) {
            this.log.println("Exception occured while testing 'exists()'");
            ex.printStackTrace(this.log);
            this.tRes.tested("exists()", false);
        }
    }

    public void _openFileRead() {
        try {
            String dirname = utils.getFullTestURL("XSimpleFileAccess");
            String filename = dirname + "XSimpleFileAccess.txt";
            XInputStream iStream = oObj.openFileRead(filename);
            this.tRes.tested("openFileRead()", iStream != null);
        }
        catch (com.sun.star.uno.Exception ex) {
            this.log.println("Exception occured while testing 'openFileRead()'");
            ex.printStackTrace(this.log);
            this.tRes.tested("openFileRead()", false);
        }
    }

    public void _openFileWrite() {
        try {
            XOutputStream oStream;
            String tmpdirname = utils.getOfficeTemp((XMultiServiceFactory)this.tParam.getMSF());
            String copiedFile = tmpdirname + "XSimpleFileAccess_openWrite.txt";
            if (oObj.exists(copiedFile)) {
                oObj.kill(copiedFile);
            }
            this.tRes.tested("openFileWrite()", (oStream = oObj.openFileWrite(copiedFile)) != null);
            oStream.closeOutput();
            oObj.kill(copiedFile);
        }
        catch (com.sun.star.uno.Exception ex) {
            this.log.println("Exception occured while testing 'openFileWrite()'");
            ex.printStackTrace(this.log);
            this.tRes.tested("openFileWrite()", false);
        }
    }

    public void _openFileReadWrite() {
        try {
            XStream aStream;
            String dirnameTo = utils.getOfficeTemp((XMultiServiceFactory)this.tParam.getMSF());
            String copiedFile = dirnameTo + "XSimpleFileAccess2.txt";
            if (oObj.exists(copiedFile)) {
                oObj.kill(copiedFile);
            }
            this.tRes.tested("openFileReadWrite()", (aStream = oObj.openFileReadWrite(copiedFile)) != null);
            aStream.getInputStream().closeInput();
            aStream.getOutputStream().closeOutput();
            oObj.kill(copiedFile);
        }
        catch (com.sun.star.uno.Exception ex) {
            this.log.println("Exception occured while testing 'openFileReadWrite()'");
            ex.printStackTrace(this.log);
            this.tRes.tested("openFileReadWrite()", false);
        }
    }

    public void _setInteractionHandler() {
        XInteractionHandler handler = null;
        Object oHandler = this.tEnv.getObjRelation("InteractionHandler");
        if (oHandler == null) {
            throw new StatusException(Status.failed("Reelation InteractionHandler not found"));
        }
        try {
            handler = UnoRuntime.queryInterface(XInteractionHandler.class, oHandler);
            oObj.setInteractionHandler(handler);
            this.tRes.tested("setInteractionHandler()", true);
        }
        catch (Exception ex) {
            this.log.println("Exception occured while testing 'setInteractionHandler()'");
            ex.printStackTrace(this.log);
            this.tRes.tested("setInteractionHandler()", false);
        }
    }
}

