/*
 * Decompiled with CFR 0.152.
 */
package ifc.ucb;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ucb.ContentProviderInfo;
import com.sun.star.ucb.DuplicateProviderException;
import com.sun.star.ucb.XContentProvider;
import com.sun.star.ucb.XContentProviderManager;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XContentProviderManager
extends MultiMethodTest {
    public XContentProviderManager oObj;
    static final String myScheme = "test-scheme";
    XContentProvider firstContentProvider;
    XContentProvider contentProvider;
    ContentProviderInfo[] initialProvidersInfo;

    @Override
    public void before() {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)this.tParam.getMSF();
        this.log.println("creating testing content providers");
        try {
            this.firstContentProvider = UnoRuntime.queryInterface(XContentProvider.class, xMSF.createInstance("com.sun.star.ucb.FileContentProvider"));
            this.contentProvider = UnoRuntime.queryInterface(XContentProvider.class, xMSF.createInstance("com.sun.star.ucb.FileContentProvider"));
        }
        catch (Exception e) {
            this.log.println("Can't create content providers " + e.getMessage());
            e.printStackTrace(this.log);
            throw new StatusException("Unexpected exception", e);
        }
    }

    public void _registerContentProvider() {
        XContentProvider result;
        this.initialProvidersInfo = this.oObj.queryContentProviders();
        this.log.println("registering the first provider");
        try {
            this.oObj.registerContentProvider(this.firstContentProvider, myScheme, false);
        }
        catch (DuplicateProviderException e) {
            this.log.println("Unexpected exception thrown " + e.getMessage());
            e.printStackTrace(this.log);
            throw new StatusException("Unexpected exception ", e);
        }
        this.log.println("registering the second provider in non-replacing mode");
        try {
            this.oObj.registerContentProvider(this.contentProvider, myScheme, false);
            Status.failed("registerContentProvider(.., .., false)");
        }
        catch (DuplicateProviderException e) {
            this.log.println("DuplicateProviderException thrown - OK");
        }
        this.log.println("registering the second provider in the replace mode");
        try {
            result = this.oObj.registerContentProvider(this.contentProvider, myScheme, true);
        }
        catch (DuplicateProviderException e) {
            this.log.println("Unexpected exception thrown " + e.getMessage());
            e.printStackTrace(this.log);
            throw new StatusException("Unexpected exception ", e);
        }
        this.tRes.tested("registerContentProvider()", result.equals(this.firstContentProvider));
    }

    public void _queryContentProviders() {
        this.executeMethod("registerContentProvider()");
        ContentProviderInfo[] providersInfo = this.oObj.queryContentProviders();
        this.tRes.tested("queryContentProviders()", providersInfo.length == this.initialProvidersInfo.length + 1);
    }

    public void _queryContentProvider() {
        this.executeMethod("registerContentProvider()");
        XContentProvider result = this.oObj.queryContentProvider("http://www.sun.com");
        this.log.println("finding queryContentProvider() result");
        boolean found = false;
        ContentProviderInfo[] providersInfo = this.oObj.queryContentProviders();
        for (int i = 0; i < providersInfo.length; ++i) {
            if (!result.equals(providersInfo[i].ContentProvider)) continue;
            found = true;
            break;
        }
        this.tRes.tested("queryContentProvider()", found);
    }

    public void _deregisterContentProvider() {
        this.executeMethod("queryContentProvider()");
        this.executeMethod("queryContentProviders()");
        this.requiredMethod("registerContentProvider()");
        this.log.println("deregistering the second provider");
        this.oObj.deregisterContentProvider(this.contentProvider, myScheme);
        XContentProvider res = this.oObj.queryContentProvider(myScheme);
        this.log.println("deregistering the first provider");
        this.oObj.deregisterContentProvider(this.firstContentProvider, myScheme);
        res = this.oObj.queryContentProvider(myScheme);
        this.tRes.tested("deregisterContentProvider()", res == null);
    }
}

