/*
 * Decompiled with CFR 0.152.
 */
package ifc.ucb;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ucb.Command;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.CommandInfo;
import com.sun.star.ucb.GlobalTransferCommandArgument;
import com.sun.star.ucb.TransferCommandOperation;
import com.sun.star.ucb.UnsupportedCommandException;
import com.sun.star.ucb.XCommandInfo;
import com.sun.star.ucb.XCommandProcessor;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.StatusException;
import util.utils;

public class _XCommandProcessor
extends MultiMethodTest {
    public XCommandProcessor oObj;
    int cmdId;

    public void _createCommandIdentifier() {
        this.log.println("creating a command line identifier");
        int testCmdId = this.oObj.createCommandIdentifier();
        this.cmdId = this.oObj.createCommandIdentifier();
        if (this.cmdId == 0 || testCmdId == 0) {
            this.log.println("createCommandLineIdentifier() returned 0 - FAILED");
        }
        if (this.cmdId == testCmdId) {
            this.log.println("the command identifier is not unique");
        }
        this.tRes.tested("createCommandIdentifier()", testCmdId != 0 && this.cmdId != 0 && this.cmdId != testCmdId);
    }

    public void _execute() {
        Object result;
        String commandName = "getCommandInfo";
        Command command = new Command(commandName, -1, null);
        this.log.println("executing command " + commandName);
        try {
            result = this.oObj.execute(command, 0, null);
        }
        catch (CommandAbortedException e) {
            this.log.println("The command aborted " + e.getMessage());
            e.printStackTrace(this.log);
            throw new StatusException("Unexpected exception", e);
        }
        catch (Exception e) {
            this.log.println("Unexpected exception " + e.getMessage());
            e.printStackTrace(this.log);
            throw new StatusException("Unexpected exception", e);
        }
        XCommandInfo xCmdInfo = UnoRuntime.queryInterface(XCommandInfo.class, result);
        CommandInfo[] cmdInfo = xCmdInfo.getCommands();
        boolean found = false;
        for (int i = 0; i < cmdInfo.length; ++i) {
            if (!cmdInfo[i].Name.equals(commandName)) continue;
            found = true;
            break;
        }
        this.log.println("testing execute with wrong command");
        Command badCommand = new Command("bad command", -1, null);
        try {
            this.oObj.execute(badCommand, 0, null);
        }
        catch (CommandAbortedException e) {
            this.log.println("CommandAbortedException thrown - OK");
        }
        catch (UnsupportedCommandException e) {
            this.log.println("UnsupportedCommandException thrown - OK");
        }
        catch (Exception e) {
            this.log.println("Wrong exception thrown " + e.getMessage());
            e.printStackTrace(this.log);
            throw new StatusException("Unexpected exception", e);
        }
        this.tRes.tested("execute()", found);
    }

    public void _abort() {
        this.executeMethod("createCommandIdentifier()");
        Command command = (Command)this.tEnv.getObjRelation("XCommandProcessor.AbortCommand");
        if (command == null) {
            String commandName = "globalTransfer";
            String srcURL = utils.getFullTestURL("SwXTextEmbeddedObject.sdw");
            String tmpURL = utils.getOfficeTemp((XMultiServiceFactory)this.tParam.getMSF());
            this.log.println("Copying '" + srcURL + "' to '" + tmpURL);
            GlobalTransferCommandArgument arg = new GlobalTransferCommandArgument(TransferCommandOperation.COPY, srcURL, tmpURL, "", 1);
            command = new Command(commandName, -1, arg);
        }
        Thread aborter = new Thread(){

            @Override
            public void run() {
                for (int i = 0; i < 10; ++i) {
                    _XCommandProcessor.this.log.println("try to abort command");
                    _XCommandProcessor.this.oObj.abort(_XCommandProcessor.this.cmdId);
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        };
        aborter.start();
        try {
            Thread.currentThread();
            Thread.sleep(15L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.log.println("executing command");
        try {
            this.oObj.execute(command, this.cmdId, null);
            this.log.println("Command execution completed");
            this.log.println("CommandAbortedException is not thrown");
            this.log.println("This is OK since there is no command implemented that can be aborted");
            this.tRes.tested("abort()", true);
        }
        catch (CommandAbortedException e) {
            this.tRes.tested("abort()", true);
        }
        catch (Exception e) {
            this.log.println("Unexpected exception " + e.getMessage());
            e.printStackTrace(this.log);
            throw new StatusException("Unexpected exception", e);
        }
        try {
            aborter.join(5000L);
            aborter.interrupt();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

