/*
 * Decompiled with CFR 0.152.
 */
package ifc.ucb;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.ucb.AlreadyInitializedException;
import com.sun.star.ucb.ListenerAlreadySetException;
import com.sun.star.ucb.XCachedDynamicResultSetFactory;
import com.sun.star.ucb.XCachedDynamicResultSetStubFactory;
import com.sun.star.ucb.XDynamicResultSet;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XCachedDynamicResultSetStubFactory
extends MultiMethodTest {
    public XCachedDynamicResultSetStubFactory oObj;
    private XDynamicResultSet resSet = null;
    private XDynamicResultSet resSetStub = null;

    @Override
    public void before() {
        this.resSet = (XDynamicResultSet)this.tEnv.getObjRelation("DynamicResultSet");
        if (this.resSet == null) {
            this.log.println("!!! Relation not found !!!");
            throw new StatusException(Status.failed("!!! Relation not found !!!"));
        }
    }

    public void _createCachedDynamicResultSetStub() {
        boolean result = true;
        this.resSetStub = this.oObj.createCachedDynamicResultSetStub(this.resSet);
        if (this.resSetStub == null) {
            this.log.println("!!! Method returned null !!!");
            result = false;
        } else {
            try {
                XResultSet resSetS = this.resSet.getStaticResultSet();
                XResultSet resSetStubS = this.resSetStub.getStaticResultSet();
                resSetStubS.last();
                int stubRowNum = resSetStubS.getRow();
                resSetS.last();
                int setRowNum = resSetS.getRow();
                result = stubRowNum == setRowNum && setRowNum > 0;
                this.log.println("Number of rows : stub=" + stubRowNum + " set=" + setRowNum);
            }
            catch (SQLException e) {
                this.log.println("!!! Something wrong with result sets :");
                e.printStackTrace(this.log);
                result = false;
            }
            catch (ListenerAlreadySetException e) {
                this.log.println("!!! Can't get static result sets :");
                e.printStackTrace(this.log);
                result = false;
            }
        }
        this.tRes.tested("createCachedDynamicResultSetStub()", result);
    }

    public void _connectToCache() {
        boolean result = true;
        XCachedDynamicResultSetFactory setFac = null;
        try {
            Object fac = ((XMultiServiceFactory)this.tParam.getMSF()).createInstance("com.sun.star.ucb.CachedDynamicResultSetFactory");
            setFac = UnoRuntime.queryInterface(XCachedDynamicResultSetFactory.class, fac);
        }
        catch (Exception e) {
            this.log.println("Cant instantiate a service");
            e.printStackTrace(this.log);
            result = false;
        }
        XDynamicResultSet rmtSet = setFac.createCachedDynamicResultSet(null, null);
        try {
            this.oObj.connectToCache(this.resSet, rmtSet, null, null);
        }
        catch (ListenerAlreadySetException e) {
            this.log.println("!!! Unexpected exception :" + e);
            result = false;
        }
        catch (AlreadyInitializedException e) {
            this.log.println("!!! Unexpected exception :" + e);
            result = false;
        }
        if (result) {
            try {
                XResultSet statRmtSet = rmtSet.getStaticResultSet();
                XResultSet statResSet = this.resSet.getStaticResultSet();
                statRmtSet.last();
                int rmtRowNum = statRmtSet.getRow();
                statResSet.last();
                int resRowNum = statResSet.getRow();
                result = rmtRowNum == resRowNum && resRowNum > 0;
                this.log.println("Number of rows : destination=" + rmtRowNum + " source=" + resRowNum);
            }
            catch (SQLException e) {
                this.log.println("!!! Something wrong with result sets :");
                e.printStackTrace(this.log);
                result = false;
            }
            catch (ListenerAlreadySetException e) {
                this.log.println("!!! Something wrong with result sets :");
                e.printStackTrace(this.log);
                result = false;
            }
        }
        this.tRes.tested("connectToCache()", result);
    }
}

