/*
 * Decompiled with CFR 0.152.
 */
package ifc.ucb;

import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.ucb.ListenerAlreadySetException;
import com.sun.star.ucb.XCachedDynamicResultSetFactory;
import com.sun.star.ucb.XDynamicResultSet;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XCachedDynamicResultSetFactory
extends MultiMethodTest {
    public XCachedDynamicResultSetFactory oObj;
    private XDynamicResultSet resSetStub = null;

    @Override
    public void before() {
        this.resSetStub = (XDynamicResultSet)this.tEnv.getObjRelation("CachedDynamicResultSetStub");
        if (this.resSetStub == null) {
            this.log.println("!!! Relation not found !!!");
            throw new StatusException(Status.failed("!!! Relation not found !!!"));
        }
    }

    public void _createCachedDynamicResultSet() {
        boolean result = true;
        XDynamicResultSet resSet = this.oObj.createCachedDynamicResultSet(this.resSetStub, null);
        if (resSet == null) {
            this.log.println("!!! Method returned null !!!");
            result = false;
        } else {
            try {
                XResultSet resSetS = resSet.getStaticResultSet();
                XResultSet resSetStubS = this.resSetStub.getStaticResultSet();
                resSetStubS.last();
                int stubRowNum = resSetStubS.getRow();
                resSetS.last();
                int setRowNum = resSetS.getRow();
                result = stubRowNum == setRowNum && setRowNum > 0;
                this.log.println("Number of rows : stub=" + stubRowNum + " set=" + setRowNum);
            }
            catch (SQLException e) {
                this.log.println("!!! Something wrong with result sets :");
                e.printStackTrace(this.log);
                result = false;
            }
            catch (ListenerAlreadySetException e) {
                this.log.println("!!! Can't get static result sets :");
                e.printStackTrace(this.log);
                result = false;
            }
        }
        this.tRes.tested("createCachedDynamicResultSet()", result);
    }
}

