/*
 * Decompiled with CFR 0.152.
 */
package ifc.text;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XDocumentIndex;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;

public class _XDocumentIndex
extends MultiMethodTest {
    public XDocumentIndex oObj = null;

    public void _getServiceName() {
        String serv = this.oObj.getServiceName();
        this.tRes.tested("getServiceName()", serv.equals("com.sun.star.text.DocumentIndex"));
    }

    public void _update() {
        boolean bOK = true;
        try {
            XTextDocument xTextDoc = (XTextDocument)this.tEnv.getObjRelation("TextDoc");
            XText xText = xTextDoc.getText();
            XTextRange xTR = xText.getEnd();
            xTR.setString("IndexMark");
            XMultiServiceFactory xDocMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xTextDoc);
            Object idxMark = xDocMSF.createInstance("com.sun.star.text.DocumentIndexMark");
            XTextContent xTC = UnoRuntime.queryInterface(XTextContent.class, idxMark);
            xText.insertTextContent(xTR, xTC, true);
        }
        catch (Exception e) {
            this.log.println("Couldn't insert index mark.");
            e.printStackTrace(this.log);
            bOK = false;
        }
        String contentBefore = this.oObj.getAnchor().getString();
        this.log.println("Content before: '" + contentBefore + "'");
        this.oObj.update();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        String contentAfter = this.oObj.getAnchor().getString();
        this.log.println("Content after: '" + contentAfter + "'");
        bOK &= !contentAfter.equals(contentBefore);
        this.tRes.tested("update()", bOK &= contentAfter.indexOf("IndexMark") > -1);
    }
}

